/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.registry;

import com.carpentersblocks.item.ItemCarpentersBed;
import com.carpentersblocks.item.ItemCarpentersChisel;
import com.carpentersblocks.item.ItemCarpentersDoor;
import com.carpentersblocks.item.ItemCarpentersHammer;
import com.carpentersblocks.item.ItemCarpentersTile;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;

public class ItemRegistry {
    public static Item itemCarpentersHammer;
    public static Item itemCarpentersChisel;
    public static Item itemCarpentersDoor;
    public static Item itemCarpentersBed;
    public static Item itemCarpentersTile;
    public static int itemCarpentersHammerID;
    public static int itemCarpentersChiselID;
    public static int itemCarpentersDoorID;
    public static int itemCarpentersBedID;
    public static int itemCarpentersTileID;
    public static boolean enableHammer;
    public static boolean enableChisel;
    public static boolean enableTile;
    public static int itemCarpentersToolsUses;
    public static boolean itemCarpentersToolsDamageable;
    public static double itemHammerDamageChanceFromSlopes;
    public static double itemHammerDamageChanceFromStairs;
    public static double itemHammerDamageChanceFromCollapsible;
    private static int recipeQuantityTile;

    public static void preInit(FMLPreInitializationEvent event, Configuration config) {
        int baseItemID = 5401;
        enableHammer = config.get("items", "Enable Hammer", enableHammer).getBoolean(enableHammer);
        enableChisel = config.get("items", "Enable Chisel", enableChisel).getBoolean(enableChisel);
        enableTile = config.get("items", "Enable Tile", enableTile).getBoolean(enableTile);
        itemCarpentersToolsUses = config.get("items", "Vanilla Tool Uses", itemCarpentersToolsUses).getInt(itemCarpentersToolsUses);
        itemCarpentersToolsDamageable = config.get("items", "Vanilla Tools Damageable", itemCarpentersToolsDamageable).getBoolean(itemCarpentersToolsDamageable);
        recipeQuantityTile = config.get("recipe quantities", "Tile", recipeQuantityTile).getInt(recipeQuantityTile);
        itemCarpentersHammerID = config.getItem("Hammer", baseItemID++).getInt(baseItemID);
        itemCarpentersChiselID = config.getItem("Chisel", baseItemID++).getInt(baseItemID);
        itemCarpentersDoorID = config.getItem("Door", baseItemID++).getInt(baseItemID);
        itemCarpentersBedID = config.getItem("Bed", baseItemID++).getInt(baseItemID);
        itemCarpentersTileID = config.getItem("Tile", baseItemID++).getInt(baseItemID);
        itemHammerDamageChanceFromSlopes = config.get("items", "itemHammerDamageChanceFromSlopes", itemHammerDamageChanceFromSlopes).getDouble(itemHammerDamageChanceFromSlopes);
        itemHammerDamageChanceFromStairs = config.get("items", "itemHammerDamageChanceFromStairs", itemHammerDamageChanceFromStairs).getDouble(itemHammerDamageChanceFromStairs);
        itemHammerDamageChanceFromCollapsible = config.get("items", "itemHammerDamageChanceFromCollapsible", itemHammerDamageChanceFromCollapsible).getDouble(itemHammerDamageChanceFromCollapsible);
        ItemRegistry.registerItems();
    }

    public static void init(FMLInitializationEvent event) {
        ItemRegistry.registerRecipes();
    }

    private static void registerItems() {
        if (enableHammer) {
            itemCarpentersHammer = new ItemCarpentersHammer(itemCarpentersHammerID - 256).func_77655_b("itemCarpentersHammer");
            GameRegistry.registerItem((Item)itemCarpentersHammer, (String)"itemCarpentersHammer");
        }
        if (enableTile) {
            itemCarpentersTile = new ItemCarpentersTile(itemCarpentersTileID - 256).func_77655_b("itemCarpentersTile");
            GameRegistry.registerItem((Item)itemCarpentersTile, (String)"itemCarpentersTile");
        }
        if (enableChisel) {
            itemCarpentersChisel = new ItemCarpentersChisel(itemCarpentersChiselID - 256).func_77655_b("itemCarpentersChisel");
            GameRegistry.registerItem((Item)itemCarpentersChisel, (String)"itemCarpentersChisel");
        }
        if (BlockRegistry.enableDoor) {
            itemCarpentersDoor = new ItemCarpentersDoor(itemCarpentersDoorID - 256).func_77655_b("itemCarpentersDoor");
            GameRegistry.registerItem((Item)itemCarpentersDoor, (String)"itemCarpentersDoor");
        }
        if (BlockRegistry.enableBed) {
            itemCarpentersBed = new ItemCarpentersBed(itemCarpentersBedID - 256).func_77655_b("itemCarpentersBed");
            GameRegistry.registerItem((Item)itemCarpentersBed, (String)"itemCarpentersBed");
        }
    }

    private static void registerRecipes() {
        if (enableHammer) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCarpentersHammer, 1), (Object[])new Object[]{"XX ", " YX", " Y ", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('Y'), BlockRegistry.blockCarpentersBlock});
        }
        if (enableChisel) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCarpentersChisel, 1), (Object[])new Object[]{"X", "Y", Character.valueOf('X'), Item.field_77703_o, Character.valueOf('Y'), BlockRegistry.blockCarpentersBlock});
        }
        if (enableTile) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCarpentersTile, recipeQuantityTile), (Object[])new Object[]{"XXX", "YYY", Character.valueOf('X'), Block.field_111032_cD, Character.valueOf('Y'), BlockRegistry.blockCarpentersBlock});
        }
        if (BlockRegistry.enableDoor) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCarpentersDoor, BlockRegistry.recipeQuantityDoor), (Object[])new Object[]{"XX", "XX", "XX", Character.valueOf('X'), BlockRegistry.blockCarpentersBlock});
        }
        if (BlockRegistry.enableBed) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemCarpentersBed, BlockRegistry.recipeQuantityBed), (Object[])new Object[]{"XXX", "YYY", Character.valueOf('X'), Block.field_72101_ab, Character.valueOf('Y'), BlockRegistry.blockCarpentersBlock});
        }
    }

    static {
        enableHammer = true;
        enableChisel = true;
        enableTile = true;
        itemCarpentersToolsUses = 400;
        itemCarpentersToolsDamageable = true;
        itemHammerDamageChanceFromSlopes = 0.75;
        itemHammerDamageChanceFromStairs = 1.0;
        itemHammerDamageChanceFromCollapsible = 0.2;
        recipeQuantityTile = 12;
    }
}

