/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.slope;

import com.carpentersblocks.data.Slope;
import com.carpentersblocks.util.registry.FeatureRegistry;
import net.minecraftforge.common.ForgeDirection;

public class SlopeUtil {
    public int getNumBoxesPerPass(Slope slope) {
        switch (slope.type) {
            case PRISM: 
            case PRISM_1P: 
            case PRISM_2P: 
            case PRISM_3P: 
            case PRISM_4P: {
                return FeatureRegistry.slopeSmoothness / 2;
            }
        }
        return FeatureRegistry.slopeSmoothness;
    }

    public int getNumPasses(Slope slope) {
        switch (slope.type) {
            case OBLIQUE_EXT: {
                return this.getNumBoxesPerPass(slope);
            }
            case OBLIQUE_INT: {
                return 3;
            }
            case WEDGE_INT: {
                return 2;
            }
            case PRISM_WEDGE: {
                return 2;
            }
            case PRISM: 
            case PRISM_1P: 
            case PRISM_2P: 
            case PRISM_3P: 
            case PRISM_4P: {
                return 5;
            }
        }
        return 1;
    }

    public float[] genBounds(Slope slope, int slice, int precision, int pass) {
        float zeroPassOffset = (float)(++pass - 1) / (float)this.getNumPasses(slope);
        float onePassOffset = (float)pass / (float)this.getNumPasses(slope);
        float zeroOffset = (float)slice / (float)precision;
        float oneOffset = (float)(slice + 1) / (float)precision;
        block0 : switch (slope.slopeID) {
            case 1: {
                return new float[]{zeroOffset, 0.0f, 1.0f - oneOffset, 1.0f, 1.0f, 1.0f};
            }
            case 3: {
                return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, 1.0f, oneOffset};
            }
            case 2: {
                return new float[]{0.0f, 0.0f, zeroOffset, oneOffset, 1.0f, 1.0f};
            }
            case 0: {
                return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f, 1.0f - zeroOffset};
            }
            case 8: {
                return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
            }
            case 10: {
                return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
            }
            case 11: {
                return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
            }
            case 9: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
            }
            case 4: {
                return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
            }
            case 6: {
                return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            case 7: {
                return new float[]{0.0f, zeroOffset, 0.0f, oneOffset, 1.0f, 1.0f};
            }
            case 5: {
                return new float[]{0.0f, zeroOffset, 0.0f, 1.0f, 1.0f, oneOffset};
            }
            case 17: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
                    }
                }
            }
            case 19: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
                    }
                }
            }
            case 18: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
                    }
                }
            }
            case 16: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
                    }
                }
            }
            case 13: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
                    }
                }
            }
            case 15: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, zeroOffset, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                }
            }
            case 14: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, zeroOffset, 0.0f, oneOffset, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
                    }
                }
            }
            case 12: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, zeroOffset, 0.0f, oneOffset, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, zeroOffset, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                }
            }
            case 25: {
                return new float[]{zeroOffset, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
            }
            case 27: {
                return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f - zeroOffset};
            }
            case 26: {
                return new float[]{0.0f, 0.0f, zeroOffset, 1.0f - zeroOffset, oneOffset, 1.0f};
            }
            case 24: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f - zeroOffset, oneOffset, 1.0f - zeroOffset};
            }
            case 21: {
                return new float[]{zeroOffset, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
            }
            case 23: {
                return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f - zeroOffset};
            }
            case 22: {
                return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f - zeroOffset, 1.0f, 1.0f};
            }
            case 20: {
                return new float[]{0.0f, 1.0f - oneOffset, 0.0f, 1.0f - zeroOffset, 1.0f, 1.0f - zeroOffset};
            }
            case 41: {
                return new float[]{zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), 0.0f, 1.0f - oneOffset * (1.0f - zeroPassOffset), 1.0f, onePassOffset, 1.0f};
            }
            case 43: {
                return new float[]{zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), 0.0f, 0.0f, 1.0f, onePassOffset, oneOffset * (1.0f - zeroPassOffset)};
            }
            case 42: {
                return new float[]{0.0f, 0.0f, zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), oneOffset * (1.0f - zeroPassOffset), onePassOffset, 1.0f};
            }
            case 40: {
                return new float[]{0.0f, 0.0f, 0.0f, oneOffset * (1.0f - zeroPassOffset), onePassOffset, 1.0f - zeroPassOffset - zeroOffset * (1.0f - zeroPassOffset)};
            }
            case 33: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 1.0f - oneOffset, 1.0f, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
                    }
                }
                break;
            }
            case 35: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                    case 2: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
                    }
                }
                break;
            }
            case 34: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, zeroOffset, oneOffset, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
                    }
                }
                break;
            }
            case 32: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f, 1.0f - zeroOffset};
                    }
                    case 2: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
                    }
                }
                break;
            }
            case 37: {
                return new float[]{zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), 1.0f - onePassOffset, 1.0f - oneOffset * (1.0f - zeroPassOffset), 1.0f, 1.0f, 1.0f};
            }
            case 39: {
                return new float[]{zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), 1.0f - onePassOffset, 0.0f, 1.0f, 1.0f, oneOffset * (1.0f - zeroPassOffset)};
            }
            case 38: {
                return new float[]{0.0f, 1.0f - onePassOffset, zeroPassOffset + zeroOffset * (1.0f - zeroPassOffset), oneOffset * (1.0f - zeroPassOffset), 1.0f, 1.0f};
            }
            case 36: {
                return new float[]{0.0f, 1.0f - onePassOffset, 0.0f, oneOffset * (1.0f - zeroPassOffset), 1.0f, 1.0f - zeroPassOffset - zeroOffset * (1.0f - zeroPassOffset)};
            }
            case 29: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 1.0f - oneOffset, 1.0f, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
                    }
                }
                break;
            }
            case 31: {
                switch (pass) {
                    case 1: {
                        return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                    case 2: {
                        return new float[]{zeroOffset, 1.0f - oneOffset, 0.0f, 1.0f, 1.0f, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, zeroOffset, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                }
                break;
            }
            case 30: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, zeroOffset, oneOffset, 1.0f, 1.0f};
                    }
                    case 2: {
                        return new float[]{0.0f, zeroOffset, 0.0f, oneOffset, 1.0f, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, 1.0f - oneOffset, zeroOffset, 1.0f, 1.0f, 1.0f};
                    }
                }
                break;
            }
            case 28: {
                switch (pass) {
                    case 1: {
                        return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f, 1.0f - zeroOffset};
                    }
                    case 2: {
                        return new float[]{0.0f, zeroOffset, 0.0f, oneOffset, 1.0f, 1.0f};
                    }
                    case 3: {
                        return new float[]{0.0f, zeroOffset, 0.0f, 1.0f, 1.0f, oneOffset};
                    }
                }
                break;
            }
            case 45: {
                return new float[]{zeroOffset * 0.5f, 0.0f, zeroOffset * 0.5f, 1.0f - zeroOffset * 0.5f, oneOffset * 0.5f, 1.0f - zeroOffset * 0.5f};
            }
            case 44: {
                return new float[]{zeroOffset * 0.5f, 1.0f - oneOffset * 0.5f, zeroOffset * 0.5f, 1.0f - zeroOffset * 0.5f, 1.0f, 1.0f - zeroOffset * 0.5f};
            }
            default: {
                boolean renderPrism = (float)(this.getNumPasses(slope) / precision) < 2.0f;
                switch (slope.slopeID) {
                    case 61: {
                        switch (pass) {
                            case 1: {
                                return new float[]{0.0f, 0.0f, zeroOffset, 1.0f, oneOffset, 1.0f};
                            }
                            case 2: {
                                if (!renderPrism) break;
                                return new float[]{zeroOffset * 0.5f, 0.0f, 0.0f, 1.0f - zeroOffset * 0.5f, oneOffset * 0.5f, 0.5f};
                            }
                        }
                        break block0;
                    }
                    case 62: {
                        switch (pass) {
                            case 1: {
                                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f - zeroOffset, oneOffset};
                            }
                            case 2: {
                                if (!renderPrism) break;
                                return new float[]{zeroOffset * 0.5f, 0.0f, 0.5f, 1.0f - zeroOffset * 0.5f, oneOffset * 0.5f, 1.0f};
                            }
                        }
                        break block0;
                    }
                    case 63: {
                        switch (pass) {
                            case 1: {
                                return new float[]{zeroOffset, 0.0f, 0.0f, 1.0f, oneOffset, 1.0f};
                            }
                            case 2: {
                                if (!renderPrism) break;
                                return new float[]{0.0f, 0.0f, zeroOffset * 0.5f, 0.5f, oneOffset * 0.5f, 1.0f - zeroOffset * 0.5f};
                            }
                        }
                        break block0;
                    }
                    case 64: {
                        switch (pass) {
                            case 1: {
                                return new float[]{0.0f, 0.0f, 0.0f, oneOffset, 1.0f - zeroOffset, 1.0f};
                            }
                            case 2: {
                                if (!renderPrism) break;
                                return new float[]{0.5f, 0.0f, zeroOffset * 0.5f, 1.0f, oneOffset * 0.5f, 1.0f - zeroOffset * 0.5f};
                            }
                        }
                        break block0;
                    }
                }
                switch (pass) {
                    case 1: {
                        if (!slope.equals(Slope.PRISM_4P_POS)) {
                            return this.genBounds(Slope.PRISM_POS, slice, precision, pass);
                        }
                        return null;
                    }
                    case 2: {
                        if (!slope.facings.contains(ForgeDirection.NORTH)) break block0;
                        return new float[]{zeroOffset * 0.5f, 0.0f, 0.0f, 1.0f - zeroOffset * 0.5f, oneOffset * 0.5f, 0.5f};
                    }
                    case 3: {
                        if (!slope.facings.contains(ForgeDirection.SOUTH)) break block0;
                        return new float[]{zeroOffset * 0.5f, 0.0f, 0.5f, 1.0f - zeroOffset * 0.5f, oneOffset * 0.5f, 1.0f};
                    }
                    case 4: {
                        if (!slope.facings.contains(ForgeDirection.WEST)) break block0;
                        return new float[]{0.0f, 0.0f, zeroOffset * 0.5f, 0.5f, oneOffset * 0.5f, 1.0f - zeroOffset * 0.5f};
                    }
                    case 5: {
                        if (!slope.facings.contains(ForgeDirection.EAST)) break block0;
                        return new float[]{0.5f, 0.0f, zeroOffset * 0.5f, 1.0f, oneOffset * 0.5f, 1.0f - zeroOffset * 0.5f};
                    }
                }
            }
        }
        return null;
    }
}

