/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Barrier;
import com.carpentersblocks.data.Gate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersBarrier
extends BlockCoverable {
    public BlockCarpentersBarrier(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        Barrier.setPost(TE, Barrier.getPost(TE) == 1 ? 0 : 1);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int type = Barrier.getType(TE);
        if (entityPlayer.func_70093_af()) {
            if (type <= 3 && ++type > 3) {
                type = 0;
            }
        } else if (type <= 3) {
            type = 4;
        } else if (++type > 6) {
            type = 0;
        }
        Barrier.setType(TE, type);
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            TEBase[] TE_list;
            for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, x, y, z)) {
                if (TE_current == null) continue;
                Block block = TE_current.func_145838_q();
                if (block.equals((Object)this)) {
                    Barrier.setType(TE, Barrier.getType(TE_current));
                    continue;
                }
                if (!block.equals(BlockRegistry.blockCarpentersGate)) continue;
                Barrier.setType(TE, Gate.getType(TE_current));
            }
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        boolean connect_ZN = this.canConnectBarrierTo((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH);
        boolean connect_ZP = this.canConnectBarrierTo((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH);
        boolean connect_XN = this.canConnectBarrierTo((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST);
        boolean connect_XP = this.canConnectBarrierTo((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST);
        float x_Low = 0.375f;
        float x_High = 0.625f;
        float z_Low = 0.375f;
        float z_High = 0.625f;
        if (connect_ZN) {
            z_Low = 0.0f;
        }
        if (connect_ZP) {
            z_High = 1.0f;
        }
        if (connect_ZN || connect_ZP) {
            this.func_149676_a(x_Low, 0.0f, z_Low, x_High, 1.5f, z_High);
            super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        }
        z_Low = 0.375f;
        z_High = 0.625f;
        if (connect_XN) {
            x_Low = 0.0f;
        }
        if (connect_XP) {
            x_High = 1.0f;
        }
        if (connect_XN || connect_XP || !connect_ZN && !connect_ZP) {
            this.func_149676_a(x_Low, 0.0f, z_Low, x_High, 1.5f, z_High);
            super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
        }
        if (connect_ZN) {
            z_Low = 0.0f;
        }
        if (connect_ZP) {
            z_High = 1.0f;
        }
        this.func_149676_a(x_Low, 0.0f, z_Low, x_High, 1.0f, z_High);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        int type = Barrier.getType(TE);
        boolean connect_ZN = this.canConnectBarrierTo(world, x, y, z - 1, ForgeDirection.SOUTH);
        boolean connect_ZP = this.canConnectBarrierTo(world, x, y, z + 1, ForgeDirection.NORTH);
        boolean connect_XN = this.canConnectBarrierTo(world, x - 1, y, z, ForgeDirection.EAST);
        boolean connect_XP = this.canConnectBarrierTo(world, x + 1, y, z, ForgeDirection.WEST);
        float x_Low = 0.0f;
        float x_High = 1.0f;
        float z_Low = 0.0f;
        float z_High = 1.0f;
        if (type <= 3) {
            x_Low = 0.375f;
            x_High = 0.625f;
            z_Low = 0.375f;
            z_High = 0.625f;
            if (connect_ZN) {
                z_Low = 0.0f;
            }
            if (connect_ZP) {
                z_High = 1.0f;
            }
            if (connect_XN) {
                x_Low = 0.0f;
            }
            if (connect_XP) {
                x_High = 1.0f;
            }
        } else {
            x_Low = 0.25f;
            x_High = 0.75f;
            z_Low = 0.25f;
            z_High = 0.75f;
            if (connect_ZN) {
                z_Low = 0.0f;
            }
            if (connect_ZP) {
                z_High = 1.0f;
            }
            if (connect_XN) {
                x_Low = 0.0f;
            }
            if (connect_XP) {
                x_High = 1.0f;
            }
            if (connect_ZN && connect_ZP && !connect_XN && !connect_XP) {
                x_Low = 0.3125f;
                x_High = 0.6875f;
            } else if (!connect_ZN && !connect_ZP && connect_XN && connect_XP) {
                z_Low = 0.3125f;
                z_High = 0.6875f;
            }
        }
        this.func_149676_a(x_Low, 0.0f, z_Low, x_High, 1.0f, z_High);
    }

    public boolean canConnectBarrierTo(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block block = world.func_147439_a(x, y, z);
        if (block.equals((Object)this) || block.equals(BlockRegistry.blockCarpentersGate)) {
            return true;
        }
        return block.isSideSolid(world, x, y, z, side);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side.equals((Object)ForgeDirection.UP);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersBarrierRenderID;
    }
}

