/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Button;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersButton
extends BlockCoverable {
    public BlockCarpentersButton(Material material) {
        super(material);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = Button.getPolarity(TE) == 0 ? 1 : 0;
        Button.setPolarity(TE, polarity);
        this.notifySideNeighbor(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, ForgeDirection.OPPOSITES[Button.getFacing(TE).ordinal()]);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return world.func_147439_a(x - dir.offsetX, y, z - dir.offsetZ).isSideSolid((IBlockAccess)world, x - dir.offsetX, y, z - dir.offsetZ, dir);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            Button.setFacing(TE, world.func_72805_g(x, y, z));
            Button.setReady(TE);
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        ForgeDirection dir;
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && Button.isReady(TE) && !this.func_149707_d(world, x, y, z, (dir = Button.getFacing(TE)).ordinal())) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        ForgeDirection dir = Button.getFacing(TE);
        float depth = this.isDepressed(TE) ? 0.0625f : 0.125f;
        switch (dir) {
            case NORTH: {
                this.func_149676_a(0.3125f, 0.375f, 1.0f - depth, 0.6875f, 0.625f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.3125f, 0.375f, 0.0f, 0.6875f, 0.625f, depth);
                break;
            }
            case WEST: {
                this.func_149676_a(1.0f - depth, 0.375f, 0.3125f, 1.0f, 0.625f, 0.6875f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, 0.375f, 0.3125f, depth, 0.625f, 0.6875f);
                break;
            }
        }
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.isDepressed(TE)) {
            World world = TE.func_145831_w();
            ForgeDirection facing = Button.getFacing(TE);
            Button.setState(TE, 1, true);
            this.notifySideNeighbor(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, facing.ordinal());
            world.func_147464_a(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this, this.func_149738_a(world));
            actionResult.setAltered();
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifySideNeighbor(world, x, y, z, Button.getFacing(TE).ordinal());
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    private boolean isDepressed(TEBase TE) {
        return Button.getState(TE) == 1;
    }

    @Override
    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return this.getPowerSupply((TEBase)world.func_147438_o(x, y, z));
        }
        return 0;
    }

    @Override
    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return Button.getFacing(TE).ordinal() == side ? this.getPowerSupply(TE) : 0;
        }
        return 0;
    }

    private int getPowerSupply(TEBase TE) {
        int polarity = Button.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (!world.field_72995_K && TE != null) {
            Button.setState(TE, 0, true);
            this.notifySideNeighbor(world, x, y, z, Button.getFacing(TE).ordinal());
        }
    }

    private void notifySideNeighbor(World world, int x, int y, int z, int side) {
        world.func_147459_d(x, y, z, (Block)this);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        world.func_147459_d(x - dir.offsetX, y, z - dir.offsetZ, (Block)this);
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersButtonRenderID;
    }
}

