/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.DaylightSensor;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersDaylightSensor;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersDaylightSensor
extends BlockCoverable {
    public BlockCarpentersDaylightSensor(Material material) {
        super(material);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_daylight_sensor_glass_top = iconRegister.func_94245_a("CarpentersBlocks:daylightsensor/daylight_sensor_glass_top");
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = DaylightSensor.getPolarity(TE) == 0 ? 1 : 0;
        DaylightSensor.setPolarity(TE, polarity);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int sensitivity = DaylightSensor.setNextSensitivity(TE);
        if (sensitivity == 0) {
            ChatHandler.sendMessageToPlayer("message.sensitivity_sleep.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.sensitivity_monsters.name", entityPlayer);
        }
        return true;
    }

    @Override
    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return DaylightSensor.isActive(TE) ? 15 : 0;
        }
        return 0;
    }

    public void updateLightLevel(World world, int x, int y, int z) {
        TEBase TE;
        if (!world.field_73011_w.field_76576_e && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            int temp_lightValue = DaylightSensor.getLightLevel(TE);
            int lightValue = world.func_72972_b(EnumSkyBlock.Sky, x, y, z) - world.field_73008_k;
            if (world.func_72911_I()) {
                lightValue = 7;
            }
            if (temp_lightValue != lightValue) {
                DaylightSensor.setLightLevel(TE, lightValue);
                world.func_147459_d(x, y, z, (Block)this);
            }
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersDaylightSensor();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersDaylightSensorRenderID;
    }
}

