/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Ladder;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersLadder
extends BlockCoverable {
    public BlockCarpentersLadder(Material material) {
        super(material);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            int data = BlockProperties.getMetadata(TE);
            switch (data) {
                case 2: {
                    this.func_149676_a(0.0f, 0.0f, 0.8125f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1875f);
                    break;
                }
                case 4: {
                    this.func_149676_a(0.8125f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 5: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1875f, 1.0f, 1.0f);
                    break;
                }
                case 0: {
                    this.func_149676_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
                    break;
                }
                default: {
                    this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
                }
            }
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                Block block = world.func_147439_a(x, y + 1, z);
                return block.isSideSolid((IBlockAccess)world, x, y + 1, z, ForgeDirection.UP) || block.equals((Object)this) && Ladder.isFreestanding((TEBase)world.func_147438_o(x, y + 1, z));
            }
            case UP: {
                Block block = world.func_147439_a(x, y - 1, z);
                return block.isSideSolid((IBlockAccess)world, x, y - 1, z, ForgeDirection.DOWN) || block.equals((Object)this) && Ladder.isFreestanding((TEBase)world.func_147438_o(x, y - 1, z));
            }
            case NORTH: {
                Block block = world.func_147439_a(x, y, z + 1);
                return block.isSideSolid((IBlockAccess)world, x, y, z + 1, ForgeDirection.SOUTH);
            }
            case SOUTH: {
                Block block = world.func_147439_a(x, y, z - 1);
                return block.isSideSolid((IBlockAccess)world, x, y, z - 1, ForgeDirection.NORTH);
            }
            case WEST: {
                Block block = world.func_147439_a(x + 1, y, z);
                return block.isSideSolid((IBlockAccess)world, x + 1, y, z, ForgeDirection.EAST);
            }
            case EAST: {
                Block block = world.func_147439_a(x - 1, y, z);
                return block.isSideSolid((IBlockAccess)world, x - 1, y, z, ForgeDirection.WEST);
            }
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int initData) {
        return side;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int metadata = world.func_72805_g(x, y, z);
            if (metadata < 2) {
                int facing = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                BlockProperties.setMetadata(TE, facing % 2 == 0 ? 0 : 1);
            } else {
                BlockProperties.setMetadata(TE, metadata);
            }
            if (!entityLiving.func_70093_af()) {
                TEBase TE_adj = null;
                if (world.func_147439_a(x, y - 1, z).equals((Object)this)) {
                    TE_adj = (TEBase)world.func_147438_o(x, y - 1, z);
                } else if (world.func_147439_a(x, y + 1, z).equals((Object)this)) {
                    TE_adj = (TEBase)world.func_147438_o(x, y + 1, z);
                }
                if (TE_adj != null) {
                    BlockProperties.setMetadata(TE, BlockProperties.getMetadata(TE_adj));
                }
            }
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            int data = BlockProperties.getMetadata(TE);
            boolean dropBlock = false;
            switch (data) {
                case 2: {
                    if (world.func_147439_a(x, y, z + 1).isSideSolid((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH)) break;
                    dropBlock = true;
                    break;
                }
                case 3: {
                    if (world.func_147439_a(x, y, z - 1).isSideSolid((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH)) break;
                    dropBlock = true;
                    break;
                }
                case 4: {
                    if (world.func_147439_a(x + 1, y, z).isSideSolid((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST)) break;
                    dropBlock = true;
                    break;
                }
                case 5: {
                    if (world.func_147439_a(x - 1, y, z).isSideSolid((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST)) break;
                    dropBlock = true;
                }
            }
            if (dropBlock) {
                this.func_149697_b(world, x, y, z, data, 0);
                world.func_147468_f(x, y, z);
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entityLiving) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersLadderRenderID;
    }
}

