/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Lever;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersLever
extends BlockCoverable {
    public BlockCarpentersLever(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_lever = iconRegister.func_94245_a("CarpentersBlocks:lever/lever");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return IconRegistry.icon_lever;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        BlockProperties.getMetadata(TE);
        int polarity = Lever.getPolarity(TE) == 0 ? 1 : 0;
        Lever.setPolarity(TE, polarity);
        this.notifySideNeighbor(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, ForgeDirection.OPPOSITES[Lever.getFacing(TE).ordinal()]);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return world.func_147439_a(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ).isSideSolid((IBlockAccess)world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int facing = world.func_72805_g(x, y, z);
            Lever.setFacing(TE, facing);
            Lever.setReady(TE);
            if (facing < 2) {
                ForgeDirection dir = BlockProperties.getDirectionFromFacing(BlockProperties.getOppositeFacing(entityLiving));
                if (dir.equals((Object)ForgeDirection.NORTH) || dir.equals((Object)ForgeDirection.SOUTH)) {
                    Lever.setAxis(TE, Lever.Axis.Z);
                }
            } else if (facing == ForgeDirection.NORTH.ordinal() || facing == ForgeDirection.SOUTH.ordinal()) {
                Lever.setAxis(TE, Lever.Axis.Z);
            }
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        ForgeDirection facing;
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && Lever.isReady(TE) && !this.func_149707_d(world, x, y, z, (facing = Lever.getFacing(TE)).ordinal())) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            ForgeDirection facing = Lever.getFacing(TE);
            Lever.Axis axis = Lever.getAxis(TE);
            float offset = 0.1875f;
            switch (facing) {
                case DOWN: {
                    if (axis.equals((Object)Lever.Axis.X)) {
                        this.func_149676_a(0.2f, 1.0f - offset, 0.5f - offset, 0.8f, 1.0f, 0.5f + offset);
                        break;
                    }
                    this.func_149676_a(0.5f - offset, 1.0f - offset, 0.2f, 0.5f + offset, 1.0f, 0.8f);
                    break;
                }
                case UP: {
                    if (axis.equals((Object)Lever.Axis.X)) {
                        this.func_149676_a(0.2f, 0.0f, 0.5f - offset, 0.8f, offset, 0.5f + offset);
                        break;
                    }
                    this.func_149676_a(0.5f - offset, 0.0f, 0.2f, 0.5f + offset, offset, 0.8f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.5f - offset, 0.2f, 1.0f - offset, 0.5f + offset, 0.8f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.5f - offset, 0.2f, 0.0f, 0.5f + offset, 0.8f, offset);
                    break;
                }
                case WEST: {
                    this.func_149676_a(1.0f - offset, 0.2f, 0.5f - offset, 1.0f, 0.8f, 0.5f + offset);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.0f, 0.2f, 0.5f - offset, offset, 0.8f, 0.5f + offset);
                    break;
                }
            }
        }
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        ForgeDirection facing = Lever.getFacing(TE);
        Lever.setState(TE, this.isActive(TE) ? 0 : 1, true);
        World world = TE.func_145831_w();
        world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this);
        this.notifySideNeighbor(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, facing.ordinal());
        actionResult.setAltered().setNoSound();
    }

    private boolean isActive(TEBase TE) {
        return Lever.getState(TE) == 1;
    }

    @Override
    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : this.getPowerSupply(TE);
    }

    @Override
    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : (Lever.getFacing(TE).ordinal() == side ? this.getPowerSupply(TE) : 0);
    }

    private int getPowerSupply(TEBase TE) {
        if (this.isActive(TE)) {
            return Lever.getPolarity(TE) == 0 ? 15 : 0;
        }
        return Lever.getPolarity(TE) == 1 ? 15 : 0;
    }

    private void notifySideNeighbor(World world, int x, int y, int z, int side) {
        world.func_147459_d(x, y, z, (Block)this);
        switch (side) {
            case 0: {
                world.func_147459_d(x, y + 1, z, (Block)this);
                break;
            }
            case 1: {
                world.func_147459_d(x, y - 1, z, (Block)this);
                break;
            }
            case 2: {
                world.func_147459_d(x, y, z + 1, (Block)this);
                break;
            }
            case 3: {
                world.func_147459_d(x, y, z - 1, (Block)this);
                break;
            }
            case 4: {
                world.func_147459_d(x + 1, y, z, (Block)this);
                break;
            }
            case 5: {
                world.func_147459_d(x - 1, y, z, (Block)this);
            }
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isActive(TE)) {
            world.func_147459_d(x, y, z, block);
            this.notifySideNeighbor(world, x, y, z, Lever.getFacing(TE).ordinal());
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersLeverRenderID;
    }
}

