/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.PressurePlate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersPressurePlate
extends BlockCoverable {
    public BlockCarpentersPressurePlate(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_full;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = PressurePlate.getPolarity(TE) == 0 ? 1 : 0;
        PressurePlate.setPolarity(TE, polarity);
        TE.func_145831_w().func_147459_d(TE.field_145851_c, TE.field_145848_d - 1, TE.field_145849_e, (Block)this);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int trigger;
        switch (PressurePlate.getTriggerEntity(TE)) {
            case 0: {
                trigger = 1;
                break;
            }
            case 1: {
                trigger = 2;
                break;
            }
            case 2: {
                trigger = 3;
                break;
            }
            default: {
                trigger = 0;
            }
        }
        PressurePlate.setTriggerEntity(TE, trigger);
        switch (trigger) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.trigger_player.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.trigger_monster.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.trigger_animal.name", entityPlayer);
                break;
            }
            case 3: {
                ChatHandler.sendMessageToPlayer("message.trigger_all.name", entityPlayer);
            }
        }
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, this.isDepressed(TE) ? 0.03125f : 0.0625f, 0.9375f);
        }
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            List entityList = world.func_72872_a(Entity.class, this.getSensitiveAABB(x, y, z));
            boolean shouldActivate = false;
            if (!entityList.isEmpty()) {
                for (int count = 0; count < entityList.size() && !shouldActivate; ++count) {
                    if (!this.shouldTrigger(TE, (Entity)entityList.get(count), world, x, y, z)) continue;
                    shouldActivate = true;
                }
            }
            if (!shouldActivate && this.isDepressed(TE)) {
                this.toggleOff(TE, world, x, y, z);
            } else {
                world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            }
        }
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && this.shouldTrigger(TE, entity, world, x, y, z) && !this.isDepressed(TE)) {
            this.toggleOn(TE, world, x, y, z);
        }
    }

    private void toggleOn(TEBase TE, World world, int x, int y, int z) {
        PressurePlate.setState(TE, 1, true);
        this.notifyNeighborsOfUpdate(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private void toggleOff(TEBase TE, World world, int x, int y, int z) {
        PressurePlate.setState(TE, 0, true);
        this.notifyNeighborsOfUpdate(world, x, y, z);
    }

    private AxisAlignedBB getSensitiveAABB(int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)((float)x + 0.125f), (double)y, (double)((float)z + 0.125f), (double)((float)x + 1.0f - 0.125f), (double)((double)y + 0.25), (double)((float)z + 1.0f - 0.125f));
    }

    private void notifyNeighborsOfUpdate(World world, int x, int y, int z) {
        world.func_147459_d(x, y, z, (Block)this);
        world.func_147459_d(x, y - 1, z, (Block)this);
    }

    private boolean isDepressed(TEBase TE) {
        return PressurePlate.getState(TE) == 1;
    }

    @Override
    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : this.getPowerSupply(TE, BlockProperties.getMetadata(TE));
    }

    @Override
    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : (side == 1 ? this.getPowerSupply(TE, BlockProperties.getMetadata(TE)) : 0);
    }

    public boolean func_149744_f() {
        return true;
    }

    private int getPowerSupply(TEBase TE, int data) {
        int polarity = PressurePlate.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    private boolean shouldTrigger(TEBase TE, Entity entity, World world, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        int trigger = PressurePlate.getTriggerEntity(TE);
        switch (trigger) {
            case 0: {
                return entity instanceof EntityPlayer;
            }
            case 1: {
                return entity.isCreatureType(EnumCreatureType.monster, false);
            }
            case 2: {
                return entity.isCreatureType(EnumCreatureType.creature, false);
            }
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifyNeighborsOfUpdate(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side != 0;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersPressurePlateRenderID;
    }
}

