/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Safe;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersSafe;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersSafe
extends BlockCoverable {
    public BlockCarpentersSafe(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_safe_light = iconRegister.func_94245_a("CarpentersBlocks:safe/safe_light");
    }

    @Override
    protected boolean canPlayerActivate(TEBase TE, EntityPlayer entityPlayer) {
        return PlayerPermissions.canPlayerEdit(TE, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, entityPlayer) || !Safe.isLocked(TE);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int facing = BlockProperties.getOppositeFacing((EntityLivingBase)entityPlayer);
        ForgeDirection dir = BlockProperties.getDirectionFromFacing(facing);
        if (dir != Safe.getFacing(TE)) {
            Safe.setFacing(TE, facing);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            boolean locked = !Safe.isLocked(TE);
            Safe.setLocked(TE, locked);
            if (locked) {
                Safe.setAutoPerm(TE, 0);
            } else {
                Safe.setAutoPerm(TE, 3);
            }
            if (locked) {
                ChatHandler.sendMessageToPlayer("message.safe_lock.name", entityPlayer);
            } else {
                ChatHandler.sendMessageToPlayer("message.safe_unlock.name", entityPlayer);
            }
            return true;
        }
        int autoPerm = Safe.getAutoPerm(TE);
        if (++autoPerm > 3) {
            autoPerm = 0;
        }
        Safe.setAutoPerm(TE, autoPerm);
        switch (autoPerm) {
            case 3: {
                ChatHandler.sendMessageToPlayer("message.automation_all.name", entityPlayer);
                break;
            }
            case 0: {
                ChatHandler.sendMessageToPlayer("message.automation_disabled.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.automation_insert.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.automation_extract.name", entityPlayer);
            }
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            Safe.setFacing(TE, BlockProperties.getOppositeFacing(entityLiving));
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        actionResult.setAltered();
        if (!Safe.isOpen(TE) && this.canPlayerActivate(TE, entityPlayer)) {
            ItemStack itemStack;
            TECarpentersSafe TE_safe = (TECarpentersSafe)TE;
            if (entityPlayer.func_70093_af() && (itemStack = entityPlayer.func_70694_bm()) != null && itemStack.func_77973_b().equals(Items.field_151043_k) && !TE_safe.hasUpgrade()) {
                TE_safe.setUpgrade();
                actionResult.decInventory().setSoundSource(itemStack);
                return;
            }
            if (!actionResult.decInv) {
                actionResult.setNoSound();
                entityPlayer.func_71007_a((IInventory)TE_safe);
            }
        } else {
            ChatHandler.sendMessageToPlayer("message.block_lock.name", entityPlayer);
        }
    }

    @Override
    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return Blocks.field_150357_h.func_149638_a(entity);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && this.isBlockSolid(world, x, y, z)) {
            return side != Safe.getFacing(TE);
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = super.getDrops(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersSafe) {
            TECarpentersSafe TE_safe = (TECarpentersSafe)TE;
            if (((TECarpentersSafe)TE).hasUpgrade()) {
                ret.add(new ItemStack(Items.field_151043_k));
            }
            for (int slot = 0; slot < TE_safe.func_70302_i_(); ++slot) {
                ItemStack itemStack = TE_safe.func_70301_a(slot);
                if (itemStack == null) continue;
                ret.add(itemStack);
            }
        }
        return ret;
    }

    @Override
    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (Safe.isOpen(TE) || !PlayerPermissions.canPlayerEdit(TE, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, entityPlayer)) {
                return -1.0f;
            }
            return super.func_149737_a(entityPlayer, world, x, y, z);
        }
        return super.func_149737_a(entityPlayer, world, x, y, z);
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersSafe();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersSafeRenderID;
    }
}

