/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Stairs;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import com.carpentersblocks.util.stairs.StairsTransform;
import com.carpentersblocks.util.stairs.StairsUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersStairs
extends BlockCoverable {
    public BlockCarpentersStairs(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_quartered;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int stairsID = BlockProperties.getMetadata(TE);
        Stairs stairs = Stairs.stairsList[stairsID];
        switch (stairs.stairsType) {
            case NORMAL_SIDE: {
                if (++stairsID <= 3) break;
                stairsID = 0;
                break;
            }
            case NORMAL: {
                if (stairs.isPositive) {
                    if (++stairsID <= 11) break;
                    stairsID = 8;
                    break;
                }
                if (++stairsID <= 7) break;
                stairsID = 4;
                break;
            }
            case NORMAL_INT: {
                if (stairs.isPositive) {
                    if (++stairsID <= 19) break;
                    stairsID = 16;
                    break;
                }
                if (++stairsID <= 15) break;
                stairsID = 12;
                break;
            }
            case NORMAL_EXT: {
                if (stairs.isPositive) {
                    if (++stairsID <= 27) break;
                    stairsID = 24;
                    break;
                }
                if (++stairsID <= 23) break;
                stairsID = 20;
            }
        }
        BlockProperties.setMetadata(TE, stairsID);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int stairsID = BlockProperties.getMetadata(TE);
        Stairs stairs = Stairs.stairsList[stairsID];
        switch (stairs.stairsType) {
            case NORMAL_SIDE: {
                stairsID += 8;
                break;
            }
            case NORMAL: {
                if (stairs.isPositive) {
                    stairsID -= 4;
                    break;
                }
                stairsID += 12;
                break;
            }
            case NORMAL_INT: {
                if (stairs.isPositive) {
                    stairsID -= 4;
                    break;
                }
                stairsID += 12;
                break;
            }
            case NORMAL_EXT: {
                if (stairs.isPositive) {
                    stairsID -= 4;
                    break;
                }
                stairsID = 0;
            }
        }
        BlockProperties.setMetadata(TE, stairsID);
        return true;
    }

    @Override
    protected void damageItemWithChance(World world, EntityPlayer entityPlayer) {
        if ((double)world.field_73012_v.nextFloat() <= ItemRegistry.itemHammerDamageChanceFromStairs) {
            super.damageItemWithChance(world, entityPlayer);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        MovingObjectPosition finalTrace = null;
        if (TE != null) {
            Stairs stairs = Stairs.stairsList[BlockProperties.getMetadata(TE)];
            StairsUtil stairsUtil = new StairsUtil();
            double currDist = 0.0;
            double maxDist = 0.0;
            for (int box = 0; box < 3; ++box) {
                float[] bounds = stairsUtil.genBounds(box, stairs);
                if (bounds == null) continue;
                this.func_149676_a(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
                MovingObjectPosition traceResult = super.func_149731_a(world, x, y, z, startVec, endVec);
                if (traceResult == null || !((currDist = traceResult.field_72307_f.func_72436_e(endVec)) > maxDist)) continue;
                finalTrace = traceResult;
                maxDist = currDist;
            }
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return finalTrace;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            AxisAlignedBB colBox = null;
            Stairs stairs = Stairs.stairsList[BlockProperties.getMetadata(TE)];
            StairsUtil stairsUtil = new StairsUtil();
            for (int box = 0; box < 3; ++box) {
                float[] bounds = stairsUtil.genBounds(box, stairs);
                if (bounds != null) {
                    colBox = AxisAlignedBB.func_72330_a((double)((float)x + bounds[0]), (double)((float)y + bounds[1]), (double)((float)z + bounds[2]), (double)((float)x + bounds[3]), (double)((float)y + bounds[4]), (double)((float)z + bounds[5]));
                }
                if (colBox == null || !axisAlignedBB.func_72326_a(colBox)) continue;
                list.add(colBox);
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && this.isBlockSolid(world, x, y, z)) {
            return Stairs.stairsList[BlockProperties.getMetadata(TE)].isFaceFull(side);
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        switch (side) {
            case 2: {
                hitX = 1.0f - hitX;
                break;
            }
            case 4: {
                hitX = hitZ;
                break;
            }
            case 5: {
                hitX = 1.0f - hitZ;
            }
        }
        if (side > 1) {
            if (hitY > 0.5f && hitX > 1.0f - hitY && hitX < hitY) {
                return side + 2;
            }
            if (hitY < 0.5f && hitX < 1.0f - hitY && hitX > hitY) {
                return side + 6;
            }
            if (hitX < 0.2f) {
                return side == 2 ? 1 : (side == 3 ? 0 : (side == 4 ? 3 : 2));
            }
            if (hitX > 0.8f) {
                return side == 2 ? 2 : (side == 3 ? 3 : (side == 4 ? 1 : 0));
            }
            if (hitY > 0.5f) {
                return side + 2;
            }
            return side + 6;
        }
        return side + 12;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int facing = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            BlockProperties.setMetadata(TE, world.func_72805_g(x, y, z));
            int stairsID = BlockProperties.getMetadata(TE);
            if (stairsID > 11) {
                switch (facing) {
                    case 0: {
                        stairsID = stairsID == 12 ? 4 : 8;
                        break;
                    }
                    case 1: {
                        stairsID = stairsID == 12 ? 7 : 11;
                        break;
                    }
                    case 2: {
                        stairsID = stairsID == 12 ? 5 : 9;
                        break;
                    }
                    case 3: {
                        stairsID = stairsID == 12 ? 6 : 10;
                    }
                }
            }
            BlockProperties.setMetadata(TE, stairsID);
            if (!entityLiving.func_70093_af()) {
                stairsID = StairsTransform.transformStairs(world, stairsID, x, y, z);
                BlockProperties.setMetadata(TE, stairsID);
                StairsTransform.transformAdjacentStairs(world, stairsID, x, y, z);
            }
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersStairsRenderID;
    }
}

