/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Bed {
    public static final byte TYPE_NORMAL = 0;

    public static final int getType(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 0xF;
    }

    public static void setType(TEBase TE, int type) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF0;
        BlockProperties.setMetadata(TE, temp |= type);
    }

    public static boolean isOccupied(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp != 0;
    }

    public static void setOccupied(TEBase TE, boolean isOccupied) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        if (isOccupied) {
            temp |= 0x10;
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static TEBase getOppositeTE(TEBase TE) {
        ForgeDirection dir = Bed.getDirection(TE);
        int x = TE.field_145851_c;
        int z = TE.field_145849_e;
        if (Bed.isHeadOfBed(TE)) {
            x = TE.field_145851_c + dir.offsetX;
            z = TE.field_145849_e + dir.offsetZ;
        } else {
            x = TE.field_145851_c - dir.offsetX;
            z = TE.field_145849_e - dir.offsetZ;
        }
        World world = TE.func_145831_w();
        if (world.func_147439_a(x, TE.field_145848_d, z).equals(BlockRegistry.blockCarpentersBed)) {
            return (TEBase)world.func_147438_o(x, TE.field_145848_d, z);
        }
        return null;
    }

    public static boolean isHeadOfBed(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x8000;
        return temp != 0;
    }

    public static void setHeadOfBed(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & Short.MAX_VALUE;
        BlockProperties.setMetadata(TE, temp |= 0x8000);
    }

    public static ForgeDirection getDirection(TEBase TE) {
        int facing = BlockProperties.getMetadata(TE) & 0x6000;
        return BlockProperties.getDirectionFromFacing(facing >> 13);
    }

    public static void setDirection(TEBase TE, int facing) {
        int temp = BlockProperties.getMetadata(TE) & 0x9FFF;
        BlockProperties.setMetadata(TE, temp |= facing << 13);
    }
}

