/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Button {
    public static final byte POLARITY_POSITIVE = 0;
    public static final byte POLARITY_NEGATIVE = 1;
    public static final byte STATE_OFF = 0;
    public static final byte STATE_ON = 1;

    public static ForgeDirection getFacing(TEBase TE) {
        return ForgeDirection.getOrientation((int)(BlockProperties.getMetadata(TE) & 7));
    }

    public static void setFacing(TEBase TE, int side) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF8;
        BlockProperties.setMetadata(TE, temp |= side);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 8;
        return temp >> 3;
    }

    public static void setState(TEBase TE, int state, boolean playSound) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF7;
        temp |= state << 3;
        World world = TE.func_145831_w();
        if (!world.field_72995_K && BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149688_o() != Material.field_151580_n && playSound && Button.getState(TE) != state) {
            world.func_72908_a((double)TE.field_145851_c + 0.5, (double)TE.field_145848_d + 0.5, (double)TE.field_145849_e + 0.5, "random.click", 0.3f, Button.getState(TE) == 1 ? 0.5f : 0.6f);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static int getPolarity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp >> 4;
    }

    public static void setPolarity(TEBase TE, int polarity) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        BlockProperties.setMetadata(TE, temp |= polarity << 4);
    }

    public static boolean isReady(TEBase TE) {
        return (BlockProperties.getMetadata(TE) & 0x20) > 1;
    }

    public static void setReady(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFDF;
        BlockProperties.setMetadata(TE, temp |= 0x20);
    }
}

