/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Gate {
    public static final byte TYPE_VANILLA = 0;
    public static final byte TYPE_VANILLA_X1 = 1;
    public static final byte TYPE_VANILLA_X2 = 2;
    public static final byte TYPE_VANILLA_X3 = 3;
    public static final byte TYPE_PICKET = 4;
    public static final byte TYPE_SHADOWBOX = 5;
    public static final byte TYPE_WALL = 6;
    public static final byte FACING_ON_X = 0;
    public static final byte FACING_ON_Z = 1;
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte DIR_POS = 0;
    public static final byte DIR_NEG = 1;

    public static int getType(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 0xF;
    }

    public static void setType(TEBase TE, int type) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF0;
        BlockProperties.setMetadata(TE, temp |= type);
    }

    public static int getFacing(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x20;
        return temp >> 5;
    }

    public static void setFacing(TEBase TE, int facing) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFDF;
        BlockProperties.setMetadata(TE, temp |= facing << 5);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x40;
        return temp >> 6;
    }

    public static void setState(TEBase TE, int state, boolean playSound) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFBF;
        temp |= state << 6;
        World world = TE.func_145831_w();
        if (!world.field_72995_K && playSound) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static int getDirOpen(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp >> 4;
    }

    public static void setDirOpen(TEBase TE, int dirOpen) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        BlockProperties.setMetadata(TE, temp |= dirOpen << 4);
    }
}

