/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Hatch {
    public static final byte TYPE_HIDDEN = 0;
    public static final byte TYPE_WINDOW = 1;
    public static final byte TYPE_SCREEN = 2;
    public static final byte TYPE_FRENCH_WINDOW = 3;
    public static final byte TYPE_PANEL = 4;
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte POSITION_LOW = 0;
    public static final byte POSITION_HIGH = 1;
    public static final byte DIR_Z_NEG = 0;
    public static final byte DIR_Z_POS = 1;
    public static final byte DIR_X_NEG = 2;
    public static final byte DIR_X_POS = 3;
    public static final byte HINGED_NONRIGID = 0;
    public static final byte HINGED_RIGID = 1;

    public static int getType(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 7;
    }

    public static void setType(TEBase TE, int type) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF8;
        BlockProperties.setMetadata(TE, temp |= type);
    }

    public static int getPos(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 8;
        return temp >> 3;
    }

    public static void setPos(TEBase TE, int position) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF7;
        BlockProperties.setMetadata(TE, temp |= position << 3);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp >> 4;
    }

    public static void setState(TEBase TE, int state) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        temp |= state << 4;
        World world = TE.func_145831_w();
        if (!world.field_72995_K) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static int getDir(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x60;
        return temp >> 5;
    }

    public static void setDir(TEBase TE, int dir) {
        int temp = BlockProperties.getMetadata(TE) & 0xFF9F;
        BlockProperties.setMetadata(TE, temp |= dir << 5);
    }

    public static int getRigidity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x80;
        return temp >> 7;
    }

    public static void setRigidity(TEBase TE, int rigid) {
        int temp = BlockProperties.getMetadata(TE) & 0xFF7F;
        BlockProperties.setMetadata(TE, temp |= rigid << 7);
    }
}

