/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;

public class PressurePlate {
    public static final byte POLARITY_POSITIVE = 0;
    public static final byte POLARITY_NEGATIVE = 1;
    public static final byte STATE_OFF = 0;
    public static final byte STATE_ON = 1;
    public static final byte TRIGGER_PLAYER = 0;
    public static final byte TRIGGER_MONSTER = 1;
    public static final byte TRIGGER_ANIMAL = 2;
    public static final byte TRIGGER_ALL = 3;

    public static int getType(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 7;
    }

    public static void setType(TEBase TE, int type) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF8;
        BlockProperties.setMetadata(TE, temp |= type);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 8;
        return temp >> 3;
    }

    public static void setState(TEBase TE, int state, boolean playSound) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF7;
        temp |= state << 3;
        World world = TE.func_145831_w();
        if (!world.field_72995_K && BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149688_o() != Material.field_151580_n && playSound && PressurePlate.getState(TE) != state) {
            world.func_72908_a((double)TE.field_145851_c + 0.5, (double)TE.field_145848_d + 0.1, (double)TE.field_145849_e + 0.5, "random.click", 0.3f, PressurePlate.getState(TE) == 1 ? 0.5f : 0.6f);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static int getPolarity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp >> 4;
    }

    public static void setPolarity(TEBase TE, int polarity) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        BlockProperties.setMetadata(TE, temp |= polarity << 4);
    }

    public static int getTriggerEntity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x60;
        return temp >> 5;
    }

    public static void setTriggerEntity(TEBase TE, int trigger) {
        int temp = BlockProperties.getMetadata(TE) & 0xFF9F;
        BlockProperties.setMetadata(TE, temp |= trigger << 5);
    }
}

