/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.entity.item;

import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.entity.item.EntityBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCarpentersTile
extends EntityBase {
    private int ticks;
    private boolean boundsSet;
    private static final byte ID_DIRECTION = 13;
    private static final byte ID_DYE = 14;
    private static final byte ID_DESIGN = 15;
    private static final byte ID_ROTATION = 16;
    private static final String TAG_DESIGN = "tile";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_DYE = "dye";
    private static final String TAG_ROTATION = "rot";
    private static final double depth = 0.0625;
    private static final double[][] bounds = new double[][]{{0.0, 0.9375, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0625, 1.0}, {0.0, 0.0, 0.9375, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 1.0, 0.0625}, {0.9375, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0625, 1.0, 1.0}};

    public EntityCarpentersTile(World world) {
        super(world);
    }

    public EntityCarpentersTile(EntityPlayer entityPlayer, World world, int x, int y, int z, ForgeDirection dir, ForgeDirection offset_side, boolean ignoreNeighbors) {
        super(world, entityPlayer);
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.setDirection(dir);
        this.setBoundingBox();
        if (!ignoreNeighbors) {
            List list = new ArrayList();
            double factor = 0.2;
            this.field_70121_D.func_72331_e(0.1, 0.1, 0.1);
            block0 : switch (offset_side) {
                case DOWN: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(0.0, -factor, 0.0));
                    break;
                }
                case UP: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(0.0, factor, 0.0));
                    break;
                }
                case NORTH: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(0.0, 0.0, -factor));
                    break;
                }
                case SOUTH: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(0.0, 0.0, factor));
                    break;
                }
                case WEST: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(-factor, 0.0, 0.0));
                    break;
                }
                case EAST: {
                    list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72317_d(factor, 0.0, 0.0));
                    break;
                }
                default: {
                    switch (dir) {
                        case DOWN: 
                        case UP: {
                            list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72314_b(factor, 0.0, factor));
                            break block0;
                        }
                        case NORTH: 
                        case SOUTH: {
                            list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72314_b(factor, factor, 0.0));
                            break block0;
                        }
                        case WEST: 
                        case EAST: {
                            list = world.func_72872_a(EntityCarpentersTile.class, this.field_70121_D.func_72314_b(0.0, factor, factor));
                            break block0;
                        }
                    }
                }
            }
            block18: for (EntityCarpentersTile tile : list) {
                if (offset_side.equals((Object)ForgeDirection.UNKNOWN)) {
                    switch (dir) {
                        case DOWN: 
                        case UP: {
                            if (tile.field_70165_t == this.field_70165_t || tile.field_70161_v == this.field_70161_v) break;
                            continue block18;
                        }
                        case NORTH: 
                        case SOUTH: {
                            if (tile.field_70165_t == this.field_70165_t || tile.field_70163_u == this.field_70163_u) break;
                            continue block18;
                        }
                        case WEST: 
                        case EAST: {
                            if (tile.field_70161_v == this.field_70161_v || tile.field_70163_u == this.field_70163_u) break;
                            continue block18;
                        }
                    }
                }
                if (!tile.getDye().equals(this.getDefaultDye())) {
                    this.setDye(tile.getDye());
                }
                if (tile.getRotation() != 0) {
                    this.setRotation(tile.getRotation());
                }
                if (!tile.hasDesign()) continue;
                this.setDesign(tile.getDesign());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_70065_x() {
    }

    protected void func_70105_a(float width, float height) {
    }

    public void func_70107_b(double x, double y, double z) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double posX, double posY, double posZ, float yaw, float pitch, int par9) {
    }

    public void func_70078_a(Entity entity) {
    }

    protected boolean func_145771_j(double x, double y, double z) {
        return false;
    }

    public String getDefaultDye() {
        return "dyeWhite";
    }

    public void playTileSound() {
        BlockProperties.playBlockSound(this.field_70170_p, new ItemStack(Blocks.field_150405_ch), (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), true);
    }

    public void playDyeSound() {
        BlockProperties.playBlockSound(this.field_70170_p, new ItemStack(Blocks.field_150354_m), (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), true);
    }

    public double[] getBounds() {
        return bounds[this.func_70096_w().func_75679_c(13)];
    }

    public void setBoundingBox() {
        double[] bounds = this.getBounds();
        this.field_70121_D.func_72324_b(this.field_70165_t + bounds[0], this.field_70163_u + bounds[1], this.field_70161_v + bounds[2], this.field_70165_t + bounds[3], this.field_70163_u + bounds[4], this.field_70161_v + bounds[5]);
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.func_70096_w().func_75679_c(13));
    }

    public void setDirection(ForgeDirection dir) {
        this.func_70096_w().func_75692_b(13, (Object)new Integer(dir.ordinal()));
    }

    public void setRotation(int rotation) {
        this.func_70096_w().func_75692_b(16, (Object)new Integer(rotation));
    }

    public void rotate() {
        int rotation = this.getRotation();
        this.setRotation(++rotation & 3);
    }

    public int getRotation() {
        return this.func_70096_w().func_75679_c(16);
    }

    public void setDye(String dye) {
        this.func_70096_w().func_75692_b(14, (Object)new String(dye));
    }

    public String getDye() {
        return this.func_70096_w().func_75681_e(14);
    }

    public boolean hasDesign() {
        return DesignHandler.listTile.contains(this.getDesign());
    }

    public void setDesign(String tile) {
        this.func_70096_w().func_75692_b(15, (Object)new String(tile));
    }

    public String getDesign() {
        return this.func_70096_w().func_75681_e(15);
    }

    public IIcon getIcon() {
        if (this.hasDesign()) {
            return IconRegistry.icon_design_tile.get(DesignHandler.listTile.indexOf(this.getDesign()));
        }
        return IconRegistry.icon_tile_blank;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.func_70096_w().func_75692_b(15, (Object)String.valueOf(nbtTagCompound.func_74779_i(TAG_DESIGN)));
        this.func_70096_w().func_75692_b(14, (Object)String.valueOf(nbtTagCompound.func_74779_i(TAG_DYE)));
        this.func_70096_w().func_75692_b(13, (Object)nbtTagCompound.func_74762_e(TAG_DIRECTION));
        this.func_70096_w().func_75692_b(16, (Object)nbtTagCompound.func_74762_e(TAG_ROTATION));
        super.func_70037_a(nbtTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74778_a(TAG_DESIGN, this.func_70096_w().func_75681_e(15));
        nbtTagCompound.func_74778_a(TAG_DYE, this.func_70096_w().func_75681_e(14));
        nbtTagCompound.func_74768_a(TAG_DIRECTION, this.func_70096_w().func_75679_c(13));
        nbtTagCompound.func_74768_a(TAG_ROTATION, this.func_70096_w().func_75679_c(16));
        super.func_70014_b(nbtTagCompound);
    }

    public void onBroken(Entity entity) {
        if (entity instanceof EntityPlayer) {
            Item item;
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            ItemStack itemStack = entityPlayer.func_70694_bm();
            boolean hasHammer = false;
            if (itemStack != null && (item = itemStack.func_77973_b()) instanceof ICarpentersHammer) {
                hasHammer = true;
            }
            if (entityPlayer.field_71075_bZ.field_75098_d && !hasHammer) {
                return;
            }
        }
        this.func_70099_a(this.getItemDrop(), 0.0f);
    }

    public void func_70071_h_() {
        if (!this.boundsSet) {
            this.setBoundingBox();
            this.boundsSet = true;
        }
        if (!this.field_70170_p.field_72995_K && this.ticks++ >= 20) {
            this.ticks = 0;
            if (!this.field_70128_L && !this.onValidSurface()) {
                this.func_70106_y();
                this.onBroken(null);
            }
        }
    }

    private ItemStack getItemDrop() {
        return new ItemStack(ItemRegistry.itemCarpentersTile);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.getItemDrop();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public boolean onValidSurface() {
        ForgeDirection dir = this.getDirection();
        int x_offset = MathHelper.func_76128_c((double)this.field_70165_t) - dir.offsetX;
        int y_offset = MathHelper.func_76128_c((double)this.field_70163_u) - dir.offsetY;
        int z_offset = MathHelper.func_76128_c((double)this.field_70161_v) - dir.offsetZ;
        return this.field_70170_p.func_147439_a(x_offset, y_offset, z_offset).isSideSolid((IBlockAccess)this.field_70170_p, x_offset, y_offset, z_offset, dir);
    }

    public boolean func_70097_a(DamageSource damageSource, float par2) {
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer entityPlayer;
            ItemStack itemStack;
            Entity entity = damageSource.func_76346_g();
            boolean dropItem = false;
            if (entity instanceof EntityPlayer && PlayerPermissions.canPlayerEdit(this, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), (EntityPlayer)entity) && (itemStack = (entityPlayer = (EntityPlayer)entity).func_70694_bm()) != null) {
                if (itemStack.func_77973_b() instanceof ICarpentersHammer) {
                    if (entity.func_70093_af()) {
                        if (!this.field_70128_L) {
                            dropItem = true;
                        }
                    } else {
                        this.setDesign(DesignHandler.getNext(TAG_DESIGN, this.getDesign()));
                    }
                } else if (entityPlayer.field_71075_bZ.field_75098_d && !this.field_70128_L) {
                    dropItem = true;
                }
            }
            this.playTileSound();
            if (dropItem) {
                this.func_70106_y();
                this.func_70018_K();
                this.onBroken(damageSource.func_76346_g());
                return true;
            }
        }
        return false;
    }

    public boolean func_130002_c(EntityPlayer entityPlayer) {
        ItemStack itemStack;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (PlayerPermissions.canPlayerEdit(this, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), entityPlayer) && (itemStack = entityPlayer.func_70694_bm()) != null) {
            if (itemStack.func_77973_b() instanceof ICarpentersHammer) {
                if (entityPlayer.func_70093_af()) {
                    this.rotate();
                } else {
                    this.setDesign(DesignHandler.getPrev(TAG_DESIGN, this.getDesign()));
                }
                this.playTileSound();
            } else if (BlockProperties.isDye(itemStack, true) && entityPlayer.func_70093_af()) {
                String dye = DyeHandler.getOreDictName(itemStack);
                if (!this.getDye().equals(dye)) {
                    this.setDye(DyeHandler.getOreDictName(itemStack));
                    this.playDyeSound();
                }
            }
            return true;
        }
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.onBroken(null);
        }
    }

    public void func_70024_g(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.onBroken(null);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(15, (Object)new String(""));
        this.func_70096_w().func_75682_a(14, (Object)new String("dyeWhite"));
        this.func_70096_w().func_75682_a(13, (Object)new Integer(0));
        this.func_70096_w().func_75682_a(16, (Object)new Integer(0));
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    protected boolean func_142008_O() {
        return false;
    }
}

