/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Hinge;
import com.carpentersblocks.renderer.BlockHandlerHinged;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersDoor
extends BlockHandlerHinged {
    private boolean hingeLeft;
    private boolean isOpen;
    private int facing;
    private int type;
    private boolean isBottom;

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    @Override
    public void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.setParams();
        ItemStack itemStack = this.getCoverForRendering();
        switch (this.type) {
            case 0: {
                this.renderTypeGlassTop(itemStack, x, y, z);
                break;
            }
            case 1: 
            case 3: {
                this.renderTypeTall(itemStack, x, y, z);
                break;
            }
            case 2: {
                this.renderTypePanels(itemStack, x, y, z);
                break;
            }
            case 4: {
                this.renderTypeFrench(itemStack, x, y, z);
                break;
            }
            case 5: {
                this.renderTypeHidden(itemStack, x, y, z);
            }
        }
        this.renderBlocks.field_147837_f = false;
    }

    private void setParams() {
        this.type = Hinge.getType(this.TE);
        this.hingeLeft = Hinge.getHinge(this.TE) == 0;
        this.isOpen = Hinge.getState(this.TE) == 1;
        this.isBottom = Hinge.getPiece(this.TE) == 0;
        int facing = Hinge.getFacing(this.TE);
        this.facing = facing == 3 ? 0 : (facing == 1 ? 1 : (facing == 2 ? 2 : 3));
        ForgeDirection[][] extrapolatedSide = new ForgeDirection[][]{{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.WEST}, {ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.NORTH}, {ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH}};
        this.side = extrapolatedSide[this.facing][!this.isOpen ? 0 : (this.hingeLeft ? 1 : 2)];
    }

    private void renderTypeFrench(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
        if (this.isBottom) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.1875, 0.875, 0.5625, 0.5, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.625, 0.875, 0.5625, 0.9375, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.5, 0.875, 0.8125, 0.625, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.9375, 0.875, 0.8125, 1.0, 0.9375, this.side);
            this.renderPartPane(IconRegistry.icon_door_french_glass_bottom, x, y, z);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.0625, 0.875, 0.5625, 0.375, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.5, 0.875, 0.5625, 0.8125, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.8125, 0.8125, 0.8125, 1.0, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.875, 0.8125, 0.0625, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.375, 0.875, 0.8125, 0.5, 0.9375, this.side);
            this.renderPartPane(IconRegistry.icon_door_french_glass_top, x, y, z);
        }
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypeGlassTop(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
        if (this.isBottom) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.1875, 0.875, 0.8125, 1.0, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.3125, 0.8125, 0.6875, 0.875, 1.0, this.side);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.8125, 0.8125, 0.8125, 1.0, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
            this.renderPartPane(IconRegistry.icon_door_glass_top, x, y, z);
        }
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypePanels(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
        if (this.isBottom) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.1875, 0.875, 0.8125, 1.0, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.3125, 0.8125, 0.6875, 0.9375, 1.0, this.side);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.875, 0.8125, 0.8125, 0.9375, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.8125, 0.8125, 0.8125, 1.0, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0625, 0.8125, 0.8125, 0.25, 1.0, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.375, 0.8125, 0.6875, 0.6875, 1.0, this.side);
        }
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypeTall(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0, this.side);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
        if (this.isBottom) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.0, 0.8125, 0.8125, 0.1875, 1.0, this.side);
            this.renderPartPane(this.type == 3 ? IconRegistry.icon_door_screen_tall : IconRegistry.icon_door_glass_tall_bottom, x, y, z);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.8125, 0.8125, 0.8125, 1.0, 1.0, this.side);
            this.renderPartPane(this.type == 3 ? IconRegistry.icon_door_screen_tall : IconRegistry.icon_door_glass_tall_top, x, y, z);
        }
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, true);
    }

    private void renderTypeHidden(ItemStack itemStack, int x, int y, int z) {
        this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.0, 0.8125, 1.0, 1.0, 1.0, this.side);
        this.renderPartHandle(new ItemStack(Blocks.field_150339_S), x, y, z, true, false);
    }

    private void renderPartHandle(ItemStack itemStack, int x, int y, int z, boolean renderInner, boolean renderOuter) {
        boolean renderOffset;
        if (!renderInner && !renderOuter) {
            return;
        }
        this.suppressDyeColor = true;
        this.suppressChiselDesign = true;
        this.suppressOverlay = true;
        float xMin = this.isOpen ? (!this.hingeLeft ? 0.875f : 0.0625f) : (!this.hingeLeft ? 0.0625f : 0.875f);
        float yMin = this.isBottom ? 0.875f : 0.0625f;
        float yMax = this.isBottom ? 0.9375f : 0.125f;
        float yMinOffset = this.isBottom ? 0.875f : 0.0f;
        float yMaxOffset = this.isBottom ? 1.0f : 0.125f;
        boolean renderSrc = renderInner && !this.isOpen || renderOuter && this.isOpen;
        boolean bl = renderOffset = renderOuter && !this.isOpen || renderInner && this.isOpen;
        if (renderSrc) {
            this.renderBlockWithRotation(itemStack, x, y, z, xMin, yMin, 0.75, xMin + 0.0625f, yMax, 0.8125, this.side);
            this.renderBlockWithRotation(itemStack, x, y, z, xMin, yMinOffset, 0.6875, xMin + 0.0625f, yMaxOffset, 0.75, this.side);
        }
        if (renderOffset) {
            ForgeDirection opp = this.side.getOpposite();
            this.renderBlockWithRotation(itemStack, x - opp.offsetX, y, z - opp.offsetZ, xMin, yMin, 0.0, xMin + 0.0625f, yMax, 0.0625, this.side);
            this.renderBlockWithRotation(itemStack, x - opp.offsetX, y, z - opp.offsetZ, xMin, yMinOffset, 0.0625, xMin + 0.0625f, yMaxOffset, 0.125, this.side);
        }
        this.suppressDyeColor = false;
        this.suppressChiselDesign = false;
        this.suppressOverlay = false;
    }
}

