/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCarpentersLever;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Lever;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersLever
extends BlockHandlerBase {
    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    @Override
    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        Block block = BlockProperties.toBlock(itemStack);
        if (block instanceof BlockCoverable) {
            return IconRegistry.icon_uncovered_solid;
        }
        return icon;
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.renderLever(this.getCoverForRendering(), x, y, z);
        this.renderBlocks.field_147837_f = false;
    }

    private void renderLever(ItemStack itemStack, int x, int y, int z) {
        BlockCarpentersLever blockRef = (BlockCarpentersLever)BlockRegistry.blockCarpentersLever;
        blockRef.func_149719_a(this.renderBlocks.field_147845_a, x, y, z);
        this.renderBlocks.func_147775_a((Block)blockRef);
        this.renderBlock(itemStack, x, y, z);
        this.renderLeverHandle(x, y, z);
    }

    private void renderLeverHandle(int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(Blocks.field_150346_d.func_149677_c(this.renderBlocks.field_147845_a, x, y, z));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        ForgeDirection facing = Lever.getFacing(this.TE);
        boolean toggleState = Lever.getState(this.TE) == 1;
        boolean rotateLever = Lever.getAxis(this.TE) == Lever.Axis.X;
        IIcon icon = this.renderBlocks.func_147744_b() ? this.renderBlocks.field_147840_d : IconRegistry.icon_lever;
        double uMin = icon.func_94209_e();
        double uMax = icon.func_94212_f();
        double vMin = icon.func_94206_g();
        double vMax = icon.func_94210_h();
        Vec3[] vector = new Vec3[8];
        float vecX = 0.0625f;
        float vecY = 0.625f;
        float vecZ = 0.0625f;
        vector[0] = Vec3.func_72443_a((double)(-vecX), (double)0.0, (double)(-vecZ));
        vector[1] = Vec3.func_72443_a((double)vecX, (double)0.0, (double)(-vecZ));
        vector[2] = Vec3.func_72443_a((double)vecX, (double)0.0, (double)vecZ);
        vector[3] = Vec3.func_72443_a((double)(-vecX), (double)0.0, (double)vecZ);
        vector[4] = Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)(-vecZ));
        vector[5] = Vec3.func_72443_a((double)vecX, (double)vecY, (double)(-vecZ));
        vector[6] = Vec3.func_72443_a((double)vecX, (double)vecY, (double)vecZ);
        vector[7] = Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)vecZ);
        for (int vecCount = 0; vecCount < 8; ++vecCount) {
            if (toggleState) {
                vector[vecCount].field_72449_c -= 0.0625;
                vector[vecCount].func_72440_a(0.69813174f);
            } else {
                vector[vecCount].field_72449_c += 0.0625;
                vector[vecCount].func_72440_a(-0.69813174f);
            }
            if (facing.ordinal() < 2) {
                if (facing.equals((Object)ForgeDirection.DOWN)) {
                    vector[vecCount].func_72446_c((float)Math.PI);
                }
                if (rotateLever) {
                    vector[vecCount].func_72442_b(1.5707964f);
                }
                if (facing.equals((Object)ForgeDirection.UP)) {
                    vector[vecCount].field_72450_a += (double)x + 0.5;
                    vector[vecCount].field_72448_b += (double)((float)y + 0.125f);
                    vector[vecCount].field_72449_c += (double)z + 0.5;
                    continue;
                }
                vector[vecCount].field_72450_a += (double)x + 0.5;
                vector[vecCount].field_72448_b += (double)((float)y + 0.875f);
                vector[vecCount].field_72449_c += (double)z + 0.5;
                continue;
            }
            vector[vecCount].field_72448_b -= 0.375;
            vector[vecCount].func_72440_a(1.5707964f);
            switch (facing) {
                case NORTH: {
                    vector[vecCount].func_72442_b(0.0f);
                    break;
                }
                case SOUTH: {
                    vector[vecCount].func_72442_b((float)Math.PI);
                    break;
                }
                case WEST: {
                    vector[vecCount].func_72442_b(1.5707964f);
                    break;
                }
                case EAST: {
                    vector[vecCount].func_72442_b(-1.5707964f);
                    break;
                }
            }
            vector[vecCount].field_72450_a += (double)x + 0.5;
            vector[vecCount].field_72448_b += (double)((float)y + 0.5f);
            vector[vecCount].field_72449_c += (double)z + 0.5;
        }
        Vec3 vertex1 = null;
        Vec3 vertex2 = null;
        Vec3 vertex3 = null;
        Vec3 vertex4 = null;
        for (int side = 0; side < 6; ++side) {
            if (side == 0) {
                uMin = icon.func_94214_a(7.0);
                vMin = icon.func_94207_b(6.0);
                uMax = icon.func_94214_a(9.0);
                vMax = icon.func_94207_b(8.0);
            } else if (side == 2) {
                uMin = icon.func_94214_a(7.0);
                vMin = icon.func_94207_b(6.0);
                uMax = icon.func_94214_a(9.0);
                vMax = icon.func_94210_h();
            }
            switch (side) {
                case 0: {
                    vertex1 = vector[0];
                    vertex2 = vector[1];
                    vertex3 = vector[2];
                    vertex4 = vector[3];
                    break;
                }
                case 1: {
                    vertex1 = vector[7];
                    vertex2 = vector[6];
                    vertex3 = vector[5];
                    vertex4 = vector[4];
                    break;
                }
                case 2: {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    vertex1 = vector[1];
                    vertex2 = vector[0];
                    vertex3 = vector[4];
                    vertex4 = vector[5];
                    break;
                }
                case 3: {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    vertex1 = vector[2];
                    vertex2 = vector[1];
                    vertex3 = vector[5];
                    vertex4 = vector[6];
                    break;
                }
                case 4: {
                    tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
                    vertex1 = vector[3];
                    vertex2 = vector[2];
                    vertex3 = vector[6];
                    vertex4 = vector[7];
                    break;
                }
                case 5: {
                    tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
                    vertex1 = vector[0];
                    vertex2 = vector[3];
                    vertex3 = vector[7];
                    vertex4 = vector[4];
                }
            }
            VertexHelper.drawVertex(this.renderBlocks, vertex1.field_72450_a, vertex1.field_72448_b, vertex1.field_72449_c, uMin, vMax);
            VertexHelper.drawVertex(this.renderBlocks, vertex2.field_72450_a, vertex2.field_72448_b, vertex2.field_72449_c, uMax, vMax);
            VertexHelper.drawVertex(this.renderBlocks, vertex3.field_72450_a, vertex3.field_72448_b, vertex3.field_72449_c, uMax, vMin);
            VertexHelper.drawVertex(this.renderBlocks, vertex4.field_72450_a, vertex4.field_72448_b, vertex4.field_72449_c, uMin, vMin);
        }
    }
}

