/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Safe;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.tileentity.TECarpentersSafe;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersSafe
extends BlockHandlerBase {
    private ForgeDirection dir;
    private boolean isOpen;
    private boolean isLocked;
    private ItemStack metal;
    private static final ItemStack ice = new ItemStack(Blocks.field_150432_aD);
    private static final ItemStack gold = new ItemStack(Blocks.field_150340_R);
    private static final ItemStack iron = new ItemStack(Blocks.field_150339_S);
    private static final List<Component> coverList = new ArrayList<Component>();
    private static final List<Component> panelList;
    private final int LOCKED_ACTIVE = 0xFF0000;
    private final int LOCKED_INACTIVE = 8271414;
    private final int UNLOCKED_ACTIVE = 65280;
    private final int UNLOCKED_INACTIVE = 3571254;
    private final int CAPACITY_ACTIVE = 255;
    private final int CAPACITY_INACTIVE = 0x383884;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        for (Component comp : coverList) {
            renderBlocks.func_147782_a(comp.xMin, comp.yMin, comp.zMin, comp.xMax, comp.yMax, comp.zMax);
            this.rotateBounds(renderBlocks, ForgeDirection.WEST);
            super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        }
        for (Component comp : panelList) {
            renderBlocks.func_147782_a(comp.xMin, comp.yMin, comp.zMin, comp.xMax, comp.yMax, comp.zMax);
            this.rotateBounds(renderBlocks, ForgeDirection.WEST);
            super.renderInventoryBlock(Blocks.field_150339_S, metadata, modelID, renderBlocks);
        }
        renderBlocks.func_147782_a(0.8125, 0.375, 0.9375, 0.875, 0.625, 1.0);
        this.rotateBounds(renderBlocks, ForgeDirection.WEST);
        super.renderInventoryBlock(Blocks.field_150339_S, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.375, 0.0625, 0.875, 0.9375, 0.9375, 0.9375);
        this.rotateBounds(renderBlocks, ForgeDirection.WEST);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.75, 0.9375, 0.25, 0.8125, 1.0);
        this.rotateBounds(renderBlocks, ForgeDirection.WEST);
        super.renderInventoryBlock(Blocks.field_150343_Z, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.8125, 0.9375, 0.25, 0.875, 1.0);
        this.rotateBounds(renderBlocks, ForgeDirection.WEST);
        super.renderInventoryBlock(Blocks.field_150343_Z, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.125, 0.125, 0.9375, 0.25, 0.6875, 1.0);
        this.rotateBounds(renderBlocks, ForgeDirection.WEST);
        super.renderInventoryBlock(Blocks.field_150343_Z, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        ItemStack itemStack = this.getCoverForRendering();
        this.dir = Safe.getFacing(this.TE);
        this.isOpen = Safe.getState(this.TE) == 1;
        this.isLocked = Safe.isLocked(this.TE);
        this.metal = ((TECarpentersSafe)this.TE).hasUpgrade() ? gold : iron;
        for (Component comp : coverList) {
            this.renderBlockWithRotation(itemStack, x, y, z, comp.xMin, comp.yMin, comp.zMin, comp.xMax, comp.yMax, comp.zMax, this.dir);
        }
        this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0625, 0.875, this.isOpen ? 0.5625 : 0.9375, 0.9375, 0.9375, this.dir);
        this.suppressDyeColor = true;
        this.suppressOverlay = true;
        this.suppressChiselDesign = true;
        for (Component comp : panelList) {
            this.renderBlockWithRotation(this.metal, x, y, z, comp.xMin, comp.yMin, comp.zMin, comp.xMax, comp.yMax, comp.zMax, this.dir);
        }
        this.renderBlockWithRotation(this.metal, x, y, z, this.isOpen ? 0.4375 : 0.8125, 0.375, 0.9375, this.isOpen ? 0.5 : 0.875, 0.625, 1.0, this.dir);
        this.disableAO = true;
        this.setIconOverride(6, IconRegistry.icon_safe_light);
        this.renderPartLockLight(x, y, z);
        this.renderPartCapacityLight(x, y, z);
        this.clearIconOverride(6);
        this.disableAO = false;
        this.suppressDyeColor = false;
        this.suppressOverlay = false;
        this.suppressChiselDesign = false;
        this.renderBlocks.field_147837_f = false;
    }

    private void renderPartCapacityLight(int x, int y, int z) {
        double yMin = 0.125;
        double yMax = 0.1875;
        TECarpentersSafe TE_safe = (TECarpentersSafe)this.TE;
        int numSlotsFilled = 0;
        for (int slot = 0; slot < TE_safe.func_70302_i_(); ++slot) {
            if (TE_safe.func_70301_a(slot) == null) continue;
            ++numSlotsFilled;
        }
        int capacity = numSlotsFilled / (3 * TE_safe.func_70302_i_() / 27);
        for (int box = 0; box < 9; ++box) {
            if (box + 1 <= capacity) {
                this.lightingHelper.setLightnessOverride(1.0f);
                this.lightingHelper.setBrightnessOverride(0xF000F0);
                this.lightingHelper.setColorOverride(255);
            } else {
                this.lightingHelper.setColorOverride(0x383884);
            }
            this.renderBlockWithRotation(ice, x, y, z, 0.125, yMin, 0.9375, 0.25, yMax, 1.0, this.dir);
            this.lightingHelper.clearColorOverride();
            this.lightingHelper.clearBrightnessOverride();
            this.lightingHelper.clearLightnessOverride();
            yMin += 0.0625;
            yMax += 0.0625;
        }
    }

    private void renderPartLockLight(int x, int y, int z) {
        if (this.isLocked) {
            this.lightingHelper.setColorOverride(3571254);
        } else {
            this.lightingHelper.setLightnessOverride(1.0f);
            this.lightingHelper.setBrightnessOverride(0xF000F0);
            this.lightingHelper.setColorOverride(65280);
        }
        this.renderBlockWithRotation(ice, x, y, z, 0.125, 0.8125, 0.9375, 0.25, 0.875, 1.0, this.dir);
        this.lightingHelper.clearColorOverride();
        this.lightingHelper.clearBrightnessOverride();
        this.lightingHelper.clearLightnessOverride();
        if (this.isLocked) {
            this.lightingHelper.setLightnessOverride(1.0f);
            this.lightingHelper.setBrightnessOverride(0xF000F0);
            this.lightingHelper.setColorOverride(0xFF0000);
        } else {
            this.lightingHelper.setColorOverride(8271414);
        }
        this.renderBlockWithRotation(ice, x, y, z, 0.125, 0.75, 0.9375, 0.25, 0.8125, 1.0, this.dir);
        this.lightingHelper.clearColorOverride();
        this.lightingHelper.clearBrightnessOverride();
        this.lightingHelper.clearLightnessOverride();
    }

    static {
        coverList.add(new Component(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
        coverList.add(new Component(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
        coverList.add(new Component(0.0625, 0.0, 0.0625, 0.3125, 0.0625, 1.0));
        coverList.add(new Component(0.375, 0.0, 0.0625, 0.9375, 0.0625, 1.0));
        coverList.add(new Component(0.0625, 0.9375, 0.0625, 0.3125, 1.0, 1.0));
        coverList.add(new Component(0.375, 0.9375, 0.0625, 0.9375, 1.0, 1.0));
        coverList.add(new Component(0.0625, 0.0, 0.0, 0.3125, 1.0, 0.0625));
        coverList.add(new Component(0.375, 0.0, 0.0, 0.9375, 1.0, 0.0625));
        coverList.add(new Component(0.3125, 0.0, 0.0, 0.375, 1.0, 1.0));
        coverList.add(new Component(0.375, 0.625, 0.0625, 0.9375, 0.6875, 0.875));
        coverList.add(new Component(0.375, 0.3125, 0.0625, 0.9375, 0.375, 0.875));
        panelList = new ArrayList<Component>();
        panelList.add(new Component(0.125, 0.875, 0.9375, 0.25, 0.9375, 1.0));
        panelList.add(new Component(0.0625, 0.0625, 0.9375, 0.125, 0.9375, 1.0));
        panelList.add(new Component(0.25, 0.0625, 0.9375, 0.3125, 0.9375, 1.0));
        panelList.add(new Component(0.125, 0.6875, 0.9375, 0.25, 0.75, 1.0));
        panelList.add(new Component(0.125, 0.0625, 0.9375, 0.25, 0.125, 1.0));
        panelList.add(new Component(0.0625, 0.0625, 0.875, 0.3125, 0.9375, 0.9375));
    }

    public static class Component {
        public double xMin;
        public double yMin;
        public double zMin;
        public double xMax;
        public double yMax;
        public double zMax;

        public Component(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
            this.xMin = xMin;
            this.yMin = yMin;
            this.zMin = zMin;
            this.xMax = xMax;
            this.yMax = yMax;
            this.zMax = zMax;
        }
    }
}

