/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Torch;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersTorch
extends BlockHandlerBase {
    private Vec3[] vec3 = new Vec3[8];

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    @Override
    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        Block block = BlockProperties.toBlock(itemStack);
        if (BlockProperties.hasCover(this.TE, 6)) {
            return block.func_149691_a(2, this.renderBlocks.field_147845_a.func_72805_g(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e));
        }
        return IconRegistry.icon_uncovered_solid;
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.disableAO = true;
        this.renderBlocks.func_147782_a(0.4375, 0.0, 0.4375, 0.5625, 0.625, 0.5625);
        this.renderTorch(this.getCoverForRendering(), x, y, z);
        this.disableAO = false;
        this.renderBlocks.field_147837_f = false;
    }

    @Override
    protected void render(int x, int y, int z, int side, IIcon icon) {
        this.renderFace(side, icon, true);
    }

    private void renderTorch(ItemStack itemStack, int x, int y, int z) {
        this.renderTorchHead(x, y, z);
        this.renderTorchHandle(itemStack, x, y, z);
    }

    private void renderTorchHead(int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(this.srcBlock.func_149677_c(this.renderBlocks.field_147845_a, this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        IIcon icon = null;
        switch (Torch.getState(this.TE)) {
            case LIT: {
                icon = IconRegistry.icon_torch_lit;
                break;
            }
            case SMOLDERING: {
                icon = IconRegistry.icon_torch_head_smoldering;
                break;
            }
            case UNLIT: {
                icon = IconRegistry.icon_torch_head_unlit;
                break;
            }
        }
        float vecX = 0.0625f;
        float vecY = 0.625f;
        float vecZ = 0.0625f;
        this.vec3 = new Vec3[]{Vec3.func_72443_a((double)(-vecX), (double)0.5, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)0.5, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)0.5, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)0.5, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)vecY, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)vecY, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)vecZ)};
        this.setRotations(Torch.getFacing(this.TE), this.vec3, x, y, z);
        for (int side = 0; side < 6; ++side) {
            this.renderFace(side, icon, false);
        }
    }

    private void renderTorchHandle(ItemStack itemStack, int x, int y, int z) {
        float vecX = 0.0625f;
        float vecY = 0.5f;
        float vecZ = 0.0625f;
        this.vec3 = new Vec3[]{Vec3.func_72443_a((double)(-vecX), (double)0.0, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)0.0, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)0.0, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)0.0, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)vecY, (double)(-vecZ)), Vec3.func_72443_a((double)vecX, (double)vecY, (double)vecZ), Vec3.func_72443_a((double)(-vecX), (double)vecY, (double)vecZ)};
        this.setRotations(Torch.getFacing(this.TE), this.vec3, x, y, z);
        this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 1);
        this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 2);
        this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 3);
        this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 4);
        this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 5);
    }

    private void setRotations(ForgeDirection facing, Vec3[] vec3, int x, int y, int z) {
        for (int vecCount = 0; vecCount < 8; ++vecCount) {
            if (facing.equals((Object)ForgeDirection.UP)) {
                vec3[vecCount].field_72450_a += (double)x + 0.5;
                vec3[vecCount].field_72448_b += (double)y;
                vec3[vecCount].field_72449_c += (double)z + 0.5;
                continue;
            }
            vec3[vecCount].field_72449_c += 0.0625;
            vec3[vecCount].func_72440_a(-1.186824f);
            vec3[vecCount].field_72448_b -= 0.4375;
            vec3[vecCount].func_72440_a(1.5707964f);
            switch (facing) {
                case NORTH: {
                    vec3[vecCount].func_72442_b(0.0f);
                    break;
                }
                case SOUTH: {
                    vec3[vecCount].func_72442_b((float)Math.PI);
                    break;
                }
                case WEST: {
                    vec3[vecCount].func_72442_b(1.5707964f);
                    break;
                }
                case EAST: {
                    vec3[vecCount].func_72442_b(-1.5707964f);
                    break;
                }
            }
            vec3[vecCount].field_72450_a += (double)x + 0.5;
            vec3[vecCount].field_72448_b += (double)((float)y + 0.1875f);
            vec3[vecCount].field_72449_c += (double)z + 0.5;
        }
    }

    private void renderFace(int side, IIcon icon, boolean isHandle) {
        double vMax;
        double vMin;
        double uMax;
        double uMin;
        if (isHandle) {
            uMin = icon.func_94214_a(7.0);
            uMax = icon.func_94214_a(9.0);
            vMin = icon.func_94206_g();
            vMax = icon.func_94207_b(8.0);
        } else {
            uMin = icon.func_94214_a(7.0);
            uMax = icon.func_94214_a(9.0);
            vMin = icon.func_94207_b(6.0);
            vMax = icon.func_94207_b(8.0);
        }
        Vec3 vertex1 = null;
        Vec3 vertex2 = null;
        Vec3 vertex3 = null;
        Vec3 vertex4 = null;
        switch (side) {
            case 0: {
                vertex1 = this.vec3[0];
                vertex2 = this.vec3[1];
                vertex3 = this.vec3[2];
                vertex4 = this.vec3[3];
                break;
            }
            case 1: {
                vertex1 = this.vec3[7];
                vertex2 = this.vec3[6];
                vertex3 = this.vec3[5];
                vertex4 = this.vec3[4];
                break;
            }
            case 2: {
                vertex1 = this.vec3[1];
                vertex2 = this.vec3[0];
                vertex3 = this.vec3[4];
                vertex4 = this.vec3[5];
                break;
            }
            case 3: {
                vertex1 = this.vec3[3];
                vertex2 = this.vec3[2];
                vertex3 = this.vec3[6];
                vertex4 = this.vec3[7];
                break;
            }
            case 4: {
                vertex1 = this.vec3[0];
                vertex2 = this.vec3[3];
                vertex3 = this.vec3[7];
                vertex4 = this.vec3[4];
                break;
            }
            case 5: {
                vertex1 = this.vec3[2];
                vertex2 = this.vec3[1];
                vertex3 = this.vec3[5];
                vertex4 = this.vec3[6];
            }
        }
        VertexHelper.drawVertex(this.renderBlocks, vertex1.field_72450_a, vertex1.field_72448_b, vertex1.field_72449_c, uMin, vMax);
        VertexHelper.drawVertex(this.renderBlocks, vertex2.field_72450_a, vertex2.field_72448_b, vertex2.field_72449_c, uMax, vMax);
        VertexHelper.drawVertex(this.renderBlocks, vertex3.field_72450_a, vertex3.field_72448_b, vertex3.field_72449_c, uMax, vMin);
        VertexHelper.drawVertex(this.renderBlocks, vertex4.field_72450_a, vertex4.field_72448_b, vertex4.field_72449_c, uMin, vMin);
    }
}

