/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.renderer.helper.LightingHelper;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

@SideOnly(value=Side.CLIENT)
public class FancyFluidsHelper {
    public static boolean render(TEBase TE, RenderBlocks renderBlocks, int x, int y, int z) {
        ItemStack itemStack = FancyFluidsHelper.getFluidBlock(renderBlocks.field_147845_a, x, y, z);
        if (itemStack != null) {
            Block block = BlockProperties.toBlock(itemStack);
            int metadata = itemStack.func_77960_j();
            if (block.func_149701_w() == MinecraftForgeClient.getRenderPass() && !block.hasTileEntity(metadata) && metadata == 0) {
                LightingHelper lightingHelper = new LightingHelper(renderBlocks);
                lightingHelper.setupLightingYPos(itemStack, x, y, z);
                lightingHelper.setupColor(x, y, z, 1, 0xFFFFFF, null);
                double fluidHeight = (block instanceof BlockLiquid ? 0.8888888880610466 : 0.875) - (double)0.001f;
                renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, fluidHeight, 1.0);
                RenderHelper.renderFaceYPos(renderBlocks, x, y, z, block.func_149691_a(1, metadata));
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFluidBlock(IBlockAccess world, int x, int y, int z) {
        int[][] offsetXZ = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}, {-1, -1}, {-1, 1}, {1, 1}, {1, -1}};
        ForgeDirection[][][] route = new ForgeDirection[][][]{{{ForgeDirection.NORTH}}, {{ForgeDirection.SOUTH}}, {{ForgeDirection.WEST}}, {{ForgeDirection.EAST}}, {{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH}}, {{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.WEST}, {ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH}}, {{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.EAST}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH}}, {{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH}}};
        for (int idx = 0; idx < offsetXZ.length; ++idx) {
            Block block = world.func_147439_a(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]);
            if (!(block instanceof BlockLiquid) && !(block instanceof IFluidBlock)) continue;
            if (idx < 4) {
                if (world.isSideSolid(x, y, z, route[idx][0][0], false)) continue;
                return new ItemStack(block, world.func_72805_g(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]));
            }
            for (int routeIdx = 0; routeIdx < 2; ++routeIdx) {
                int[] bridgeXZ;
                if (world.isSideSolid(x, y, z, route[idx][routeIdx][0], false) || world.isSideSolid((bridgeXZ = new int[]{x + route[idx][routeIdx][0].offsetX, z + route[idx][routeIdx][0].offsetZ})[0], y, bridgeXZ[1], route[idx][routeIdx][1], false) || world.isSideSolid(bridgeXZ[0], y, bridgeXZ[1], route[idx][routeIdx][2], false)) continue;
                return new ItemStack(block, world.func_72805_g(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]));
            }
        }
        return null;
    }
}

