/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.renderer.BlockHandlerSloped;
import com.carpentersblocks.renderer.helper.VertexHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderHelper
extends VertexHelper {
    private static boolean rotationOverride = false;
    private static int rotation;
    private static double uMin;
    private static double uMax;
    private static double vMin;
    private static double vMax;
    protected static double xMin;
    protected static double xMax;
    protected static double yMin;
    protected static double yMax;
    protected static double zMin;
    protected static double zMax;
    protected static double uTL;
    protected static double vTL;
    protected static double uBL;
    protected static double vBL;
    protected static double uBR;
    protected static double vBR;
    protected static double uTR;
    protected static double vTR;
    public static final double OFFSET_MAX = 0.001953125;
    public static final double OFFSET_MIN = 9.765625E-4;
    public static double renderOffset;

    public static void setOffset(double offset) {
        renderOffset = offset;
    }

    public static void clearOffset() {
        renderOffset = 0.0;
    }

    public static void setTextureRotationOverride(int in_rotation) {
        rotationOverride = true;
        rotation = in_rotation;
    }

    public static void clearTextureRotationOverride() {
        rotationOverride = false;
    }

    private static void setCornerUV(double t_uTL, double t_vTL, double t_uBL, double t_vBL, double t_uBR, double t_vBR, double t_uTR, double t_vTR) {
        uTL = t_uTL;
        vTL = t_vTL;
        uBL = t_uBL;
        vBL = t_vBL;
        uBR = t_uBR;
        vBR = t_vBR;
        uTR = t_uTR;
        vTR = t_vTR;
    }

    protected static void prepareRender(RenderBlocks renderBlocks, ForgeDirection side, double x, double y, double z, IIcon icon) {
        if (icon == BlockGrass.func_149990_e() || icon.func_94215_i().contains("overlay/overlay_") && icon.func_94215_i().endsWith("_side")) {
            RenderHelper.setFloatingIcon();
        }
        xMin = x + renderBlocks.field_147859_h - renderOffset;
        xMax = x + renderBlocks.field_147861_i + renderOffset;
        yMin = y + renderBlocks.field_147855_j - renderOffset;
        yMax = y + renderBlocks.field_147857_k + renderOffset;
        zMin = z + renderBlocks.field_147851_l - renderOffset;
        zMax = z + renderBlocks.field_147853_m + renderOffset;
        if (BlockHandlerSloped.isSideSloped) {
            switch (side) {
                case DOWN: {
                    yMin -= renderOffset;
                    yMax -= renderOffset;
                    break;
                }
                case UP: {
                    yMin += renderOffset;
                    yMax += renderOffset;
                    break;
                }
                case NORTH: {
                    zMin -= renderOffset;
                    zMax -= renderOffset;
                    break;
                }
                case SOUTH: {
                    zMin += renderOffset;
                    zMax += renderOffset;
                    break;
                }
                case WEST: {
                    xMin -= renderOffset;
                    xMax -= renderOffset;
                    break;
                }
                case EAST: {
                    xMin += renderOffset;
                    xMax += renderOffset;
                    break;
                }
            }
        }
        if (!rotationOverride) {
            switch (side) {
                case DOWN: {
                    rotation = renderBlocks.field_147865_v;
                    break;
                }
                case UP: {
                    rotation = renderBlocks.field_147867_u;
                    break;
                }
                case NORTH: {
                    rotation = renderBlocks.field_147869_t;
                    break;
                }
                case SOUTH: {
                    rotation = renderBlocks.field_147871_s;
                    break;
                }
                case WEST: {
                    rotation = renderBlocks.field_147873_r;
                    break;
                }
                case EAST: {
                    rotation = renderBlocks.field_147875_q;
                    break;
                }
            }
        }
        switch (side) {
            case DOWN: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                    }
                }
                break;
            }
            case UP: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                    }
                }
                break;
            }
            case NORTH: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case SOUTH: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147859_h * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147861_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147859_h * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147861_i * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case WEST: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case EAST: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147851_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_147857_k) * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_147857_k - renderBlocks.field_147855_j) : renderBlocks.field_147855_j) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147853_m * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147851_l * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(renderBlocks.field_147853_m * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147851_l * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_147855_j * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_147857_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_147857_k * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_147855_j * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_147853_m * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_147851_l * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
        }
    }

    public static void renderFaceYNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uTR, vTR, 3);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uTL, vTL, 0);
    }

    public static void renderFaceYPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceZNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uTR, vTR, 3);
    }

    public static void renderFaceZPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceXNeg(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceXPos(RenderBlocks renderBlocks, double x, double y, double z, IIcon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uTR, vTR, 3);
    }
}

