/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.tileentity;

import com.carpentersblocks.data.Safe;
import com.carpentersblocks.tileentity.TEBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TECarpentersSafe
extends TEBase
implements ISidedInventory {
    private final String TAG_UPGRADE = "upgrade";
    private final String TAG_SLOT = "Slot";
    private final String TAG_ITEMS = "Items";
    private ItemStack[] inventoryContents = new ItemStack[54];
    private boolean hasUpgrade = false;
    private int tickCount;
    private boolean contentsChanged;
    private boolean forceEntityUpdate;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && (++this.tickCount >= 20 || this.forceEntityUpdate)) {
            this.tickCount = 0;
            if (this.contentsChanged) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.forceEntityUpdate = false;
                this.contentsChanged = false;
            }
        }
    }

    public boolean hasUpgrade() {
        return this.hasUpgrade;
    }

    public void setUpgrade() {
        this.hasUpgrade = true;
        this.func_70296_d();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70302_i_() {
        return this.hasUpgrade ? 54 : 27;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventoryContents[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack itemStack = null;
        if (this.inventoryContents[slot] != null) {
            if (this.inventoryContents[slot].field_77994_a <= size) {
                itemStack = this.inventoryContents[slot];
                this.inventoryContents[slot] = null;
            } else {
                itemStack = this.inventoryContents[slot].func_77979_a(size);
                if (this.inventoryContents[slot].field_77994_a == 0) {
                    this.inventoryContents[slot] = null;
                }
            }
        }
        if (itemStack == null) {
            return null;
        }
        this.func_70296_d();
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventoryContents[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.contentsChanged = true;
        super.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasUpgrade = nbt.func_74764_b("inventorySize") ? nbt.func_74762_e("inventorySize") > 27 : nbt.func_74767_n("upgrade");
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventoryContents = new ItemStack[54];
        for (int idx = 0; idx < nbttaglist.func_74745_c(); ++idx) {
            NBTTagCompound nbt1 = nbttaglist.func_150305_b(idx);
            int j = nbt1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventoryContents.length) continue;
            this.inventoryContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("upgrade", this.hasUpgrade);
        NBTTagList nbttaglist = new NBTTagList();
        for (int idx = 0; idx < this.inventoryContents.length; ++idx) {
            if (this.inventoryContents[idx] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)idx);
            this.inventoryContents[idx].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).equals(this)) {
            return entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
        }
        return false;
    }

    public void func_70295_k_() {
        Safe.setState(this, 1);
    }

    public void func_70305_f() {
        Safe.setState(this, 0);
        this.forceEntityUpdate = true;
    }

    public String func_145825_b() {
        return "tile.blockCarpentersSafe.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int[] func_94128_d(int side) {
        int sizeInventory = this.func_70302_i_();
        int[] accessibleSlots = new int[sizeInventory];
        for (int idx = 0; idx < sizeInventory; ++idx) {
            accessibleSlots[idx] = idx;
        }
        return accessibleSlots;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return Safe.allowsInsertion(this) && Safe.getFacing(this).ordinal() != side;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return Safe.allowsExtraction(this) && Safe.getFacing(this).ordinal() != side;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }
}

