/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockProperties {
    public static final Block.SoundType stepSound = new Block.SoundType("CarpentersBlocks", 1.0f, 1.0f);
    public static final int MASK_DEFAULT_ICON = 16;
    private static boolean suppressUpdate = false;

    public static boolean isMetadataDefaultIcon(int metadata) {
        return (metadata & 0x10) > 0;
    }

    public static void dropAttribute(TEBase TE, ItemStack itemStack) {
        TE.func_145831_w().func_147452_c(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, TE.func_145838_q(), Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77960_j());
    }

    public static void prepareItemStackForRendering(ItemStack itemStack) {
        if (BlockProperties.toBlock(itemStack) instanceof BlockCoverable) {
            itemStack.func_77964_b(itemStack.func_77960_j() | 0x10);
        }
    }

    public static void setHostMetadata(TEBase TE, int metadata) {
        TE.func_145831_w().func_72921_c(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, metadata, 4);
    }

    public static void resetHostMetadata(TEBase TE) {
        TE.func_145831_w().func_72921_c(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, BlockProperties.getCover(TE, 6).func_77960_j(), 4);
    }

    public static Block toBlock(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock) {
            return Block.func_149634_a((Item)itemStack.func_77973_b());
        }
        return Blocks.field_150350_a;
    }

    public static float getSideCoverDepth(TEBase TE, int side) {
        Block block;
        if (side == 1 && BlockProperties.hasCover(TE, side) && ((block = BlockProperties.toBlock(BlockProperties.getCover(TE, side))).equals(Blocks.field_150433_aE) || block.equals(Blocks.field_150431_aC))) {
            return 0.125f;
        }
        return 0.0625f;
    }

    public static int getOppositeFacing(EntityLivingBase entityLiving) {
        return MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    public static ForgeDirection getDirectionFromFacing(int facing) {
        switch (facing) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static boolean hasDesign(TEBase TE) {
        return DesignHandler.getListForType(BlockProperties.getBlockDesignType(TE)).contains(BlockProperties.getDesign(TE));
    }

    public static String getDesign(TEBase TE) {
        return TE.design;
    }

    public static boolean setDesign(TEBase TE, String name) {
        if (!TE.design.equals(name)) {
            TE.design = name;
            if (!suppressUpdate) {
                TE.func_145831_w().func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public static boolean clearDesign(TEBase TE) {
        return BlockProperties.setDesign(TE, "");
    }

    public static String getBlockDesignType(TEBase TE) {
        String name = TE.func_145838_q().func_149739_a();
        return name.substring(new String("tile.blockCarpenters").length()).toLowerCase();
    }

    public static boolean setNextDesign(TEBase TE) {
        return BlockProperties.setDesign(TE, DesignHandler.getNext(BlockProperties.getBlockDesignType(TE), BlockProperties.getDesign(TE)));
    }

    public static boolean setPrevDesign(TEBase TE) {
        return BlockProperties.setDesign(TE, DesignHandler.getPrev(BlockProperties.getBlockDesignType(TE), BlockProperties.getDesign(TE)));
    }

    public static boolean blockRotates(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        return block instanceof BlockQuartz || block instanceof BlockRotatedPillar;
    }

    public static void playBlockSound(World world, ItemStack itemStack, int x, int y, int z, boolean reducedVolume) {
        if (itemStack != null) {
            Block block = itemStack.func_77973_b() instanceof ItemBlock ? BlockProperties.toBlock(itemStack) : Blocks.field_150354_m;
            Block.SoundType soundType = block.field_149762_H;
            float volume = (soundType.func_150497_c() + 1.0f) / (reducedVolume ? 8.0f : 2.0f);
            float pitch = soundType.func_150494_d() * 0.8f;
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), soundType.func_150496_b(), volume, pitch);
        }
    }

    public static boolean hasAttribute(TEBase TE, int side) {
        return BlockProperties.hasCover(TE, side) || BlockProperties.hasDye(TE, side) || BlockProperties.hasOverlay(TE, side);
    }

    public static void ejectAttributes(TEBase TE, int side) {
        suppressUpdate = true;
        BlockProperties.setCover(TE, side, null);
        BlockProperties.setDye(TE, side, null);
        BlockProperties.setOverlay(TE, side, null);
        BlockProperties.setChiselDesign(TE, side, "");
        suppressUpdate = false;
        TE.func_145831_w().func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
    }

    public static boolean hasCover(TEBase TE, int side) {
        return TE.cover[side] != null && BlockProperties.isCover(TE.cover[side]);
    }

    public static boolean hasSideCovers(TEBase TE) {
        for (int side = 0; side < 6; ++side) {
            if (!BlockProperties.hasCover(TE, side)) continue;
            return true;
        }
        return false;
    }

    private static ItemStack getCoverUnfiltered(TEBase TE, int side) {
        return TE.cover[side] != null ? TE.cover[side] : new ItemStack(TE.func_145838_q());
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getCoverForRendering(TEBase TE, int side) {
        return BlockProperties.getCoverUnfiltered(TE, side);
    }

    public static ItemStack getCover(TEBase TE, int side) {
        ItemStack itemStack = BlockProperties.getCoverUnfiltered(TE, side);
        Block block = BlockProperties.toBlock(itemStack);
        return block.hasTileEntity(itemStack.func_77960_j()) && !(block instanceof BlockCoverable) ? new ItemStack(Blocks.field_150344_f) : itemStack;
    }

    public static boolean isCover(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock && !BlockProperties.isOverlay(itemStack)) {
            Block block = BlockProperties.toBlock(itemStack);
            return block.func_149686_d() || block instanceof BlockSlab || block instanceof BlockPane || block instanceof BlockBreakable || FeatureRegistry.coverExceptions.contains(itemStack.func_82833_r()) || FeatureRegistry.coverExceptions.contains(ChatHandler.getDefaultTranslation(itemStack));
        }
        return false;
    }

    public static ItemStack getCoverForDrop(Random rand, ItemStack itemStack) {
        if (itemStack != null) {
            Block block = BlockProperties.toBlock(itemStack);
            int damageDropped = block.func_149692_a(itemStack.func_77960_j());
            Item itemDropped = block.func_149650_a(itemStack.func_77960_j(), rand, 0);
            if (itemDropped != null && itemDropped.equals(itemStack.func_77973_b()) && damageDropped != itemStack.func_77960_j()) {
                itemStack.func_77964_b(damageDropped);
            }
        }
        return itemStack;
    }

    public static ItemStack getCoverForDrop(TEBase TE, int side) {
        return BlockProperties.getCoverForDrop(TE.func_145831_w().field_73012_v, TE.cover[side]);
    }

    public static boolean setCover(TEBase TE, int side, ItemStack itemStack) {
        int metadata;
        World world = TE.func_145831_w();
        if (BlockProperties.hasCover(TE, side)) {
            BlockProperties.dropAttribute(TE, BlockProperties.getCoverForDrop(TE, side));
        }
        TE.cover[side] = BlockProperties.getReducedStack(itemStack);
        Block block = itemStack == null ? TE.func_145838_q() : BlockProperties.toBlock(itemStack);
        int n = metadata = itemStack == null ? 0 : itemStack.func_77960_j();
        if (side == 6) {
            world.func_72921_c(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, metadata, 0);
        }
        world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, block);
        world.func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        return true;
    }

    @Deprecated
    public static final int getData(TEBase TE) {
        return BlockProperties.getMetadata(TE);
    }

    public static final int getMetadata(TEBase TE) {
        return TE.metadata & 0xFFFF;
    }

    public static boolean setMetadata(TEBase TE, int data) {
        if (data != BlockProperties.getMetadata(TE)) {
            TE.metadata = (short)data;
            if (!suppressUpdate) {
                TE.func_145831_w().func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public static boolean isDye(ItemStack itemStack, boolean allowWhite) {
        return itemStack.func_77973_b() != null && DyeHandler.isDye(itemStack, allowWhite);
    }

    public static boolean hasDye(TEBase TE, int side) {
        return TE.dye[side] != null && BlockProperties.isDye(TE.dye[side], true);
    }

    public static boolean setDye(TEBase TE, int side, ItemStack itemStack) {
        World world = TE.func_145831_w();
        if (BlockProperties.hasDye(TE, side)) {
            BlockProperties.dropAttribute(TE, BlockProperties.getDye(TE, side));
        }
        TE.dye[side] = BlockProperties.getReducedStack(itemStack);
        if (!suppressUpdate) {
            world.func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        }
        return true;
    }

    public static ItemStack getDye(TEBase TE, int side) {
        return TE.dye[side];
    }

    public static boolean setOverlay(TEBase TE, int side, ItemStack itemStack) {
        World world = TE.func_145831_w();
        if (BlockProperties.hasOverlay(TE, side)) {
            BlockProperties.dropAttribute(TE, BlockProperties.getOverlay(TE, side));
        }
        TE.overlay[side] = BlockProperties.getReducedStack(itemStack);
        if (!suppressUpdate) {
            world.func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        }
        return true;
    }

    public static ItemStack getReducedStack(ItemStack itemStack) {
        if (itemStack == null) {
            return itemStack;
        }
        ItemStack tempStack = itemStack.func_77946_l();
        tempStack.field_77994_a = 1;
        return tempStack;
    }

    public static ItemStack getOverlay(TEBase TE, int side) {
        return TE.overlay[side];
    }

    public static boolean hasOverlay(TEBase TE, int side) {
        return TE.overlay[side] != null && BlockProperties.isOverlay(TE.overlay[side]);
    }

    public static boolean isOverlay(ItemStack itemStack) {
        return OverlayHandler.overlayMap.containsKey(itemStack.func_82833_r()) || OverlayHandler.overlayMap.containsKey(ChatHandler.getDefaultTranslation(itemStack));
    }

    public static boolean hasChiselDesign(TEBase TE, int side) {
        return DesignHandler.listChisel.contains(BlockProperties.getChiselDesign(TE, side));
    }

    public static String getChiselDesign(TEBase TE, int side) {
        return TE.chiselDesign[side];
    }

    public static boolean setChiselDesign(TEBase TE, int side, String iconName) {
        if (!TE.chiselDesign.equals(iconName)) {
            TE.chiselDesign[side] = iconName;
            if (!suppressUpdate) {
                TE.func_145831_w().func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            }
            return true;
        }
        return false;
    }
}

