/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.flowerpot;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersFlowerPot;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class FlowerPotProperties {
    public static Block toBlock(ItemStack itemStack) {
        Block plant = FlowerPotHandler.itemPlant.get(itemStack.func_77973_b());
        if (plant != null) {
            return plant;
        }
        return BlockProperties.toBlock(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getPlantColor(TEBase TE) {
        ItemStack itemStack = FlowerPotProperties.getPlant(TE);
        Block block = FlowerPotProperties.toBlock(itemStack);
        BlockProperties.setHostMetadata(TE, itemStack.func_77960_j());
        int color1 = block.func_149635_D();
        int color2 = block.func_149720_d((IBlockAccess)TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        BlockProperties.resetHostMetadata(TE);
        return color1 < color2 ? color1 : color2;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlantColorable(TEBase TE) {
        return FlowerPotProperties.getPlantColor(TE) != 0xFFFFFF;
    }

    public static boolean hasSoil(TEBase TE) {
        ItemStack itemStack = ((TECarpentersFlowerPot)TE).soil;
        return itemStack != null && FlowerPotProperties.isSoil(itemStack);
    }

    public static boolean isSoil(ItemStack itemStack) {
        Block block;
        if (itemStack.func_77973_b() instanceof ItemBlock && !(block = BlockProperties.toBlock(itemStack)).hasTileEntity(itemStack.func_77960_j())) {
            Material material = block.func_149688_o();
            return material.equals(Material.field_151577_b) || material.equals(Material.field_151578_c) || material.equals(Material.field_151595_p);
        }
        return false;
    }

    public static ItemStack getSoil(TEBase TE) {
        return ((TECarpentersFlowerPot)TE).soil;
    }

    public static boolean setSoil(TEBase TE, ItemStack itemStack) {
        World world = TE.func_145831_w();
        if (FlowerPotProperties.hasSoil(TE)) {
            BlockProperties.dropAttribute(TE, FlowerPotProperties.getSoil(TE));
        }
        ((TECarpentersFlowerPot)TE).soil = BlockProperties.getReducedStack(itemStack);
        world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, BlockProperties.toBlock(itemStack));
        world.func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        return true;
    }

    public static boolean hasPlant(TEBase TE) {
        ItemStack itemStack = ((TECarpentersFlowerPot)TE).plant;
        return itemStack != null && FlowerPotProperties.isPlant(itemStack);
    }

    public static boolean isPlant(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        if (!block.equals(Blocks.field_150350_a)) {
            if (!block.hasTileEntity(itemStack.func_77960_j())) {
                return block instanceof IPlantable || block instanceof IShearable;
            }
            return false;
        }
        return FlowerPotHandler.itemPlant.containsKey(itemStack.func_77973_b());
    }

    public static ItemStack getPlant(TEBase TE) {
        return ((TECarpentersFlowerPot)TE).plant;
    }

    public static boolean setPlant(TEBase TE, ItemStack itemStack) {
        World world = TE.func_145831_w();
        if (FlowerPotProperties.hasPlant(TE)) {
            BlockProperties.dropAttribute(TE, FlowerPotProperties.getPlant(TE));
        }
        ((TECarpentersFlowerPot)TE).plant = BlockProperties.getReducedStack(itemStack);
        world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, BlockProperties.toBlock(itemStack));
        world.func_147471_g(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        return true;
    }
}

