/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.renderer.QuadContainer;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.AttributeHelper;
import com.carpentersblocks.util.attribute.AttributeItemStack;
import com.carpentersblocks.util.attribute.AttributeString;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.block.BlockUtil;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.SpriteRegistry;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public abstract class AbstractBakedModel
implements IBakedModel {
    private static final int NO_COLOR = 0xFFFFFF;
    private static final List<BlockRenderLayer> LAYERS = Arrays.asList(BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.CUTOUT, BlockRenderLayer.TRANSLUCENT);
    private static final double SIDE_DEPTH = 0.0625;
    private static final double SNOW_SIDE_DEPTH = 0.125;
    protected boolean _renderY;
    protected boolean _renderX;
    protected boolean _renderZ;
    protected AttributeHelper _cbAttrHelper;
    protected IBlockState _blockState;
    protected int _cbMetadata;
    protected BlockPos _blockPos;
    protected Boolean[] _renderFace;
    private long _rand;
    private QuadContainer _quadContainer;
    private BlockRenderLayer _uncoveredRenderLayer;
    private VertexFormat _format;
    private boolean _isSideCover;
    private double _sideDepth;
    private boolean _isSnowCover;
    EnumAttributeLocation _location;

    public AbstractBakedModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this._format = format;
    }

    public VertexFormat getFormat() {
        return this._format;
    }

    public IBlockState appendAttributeBlockState(CbTileEntity cbTileEntity, IBlockState blockState, EnumAttributeLocation location, EnumAttributeType type) {
        if (cbTileEntity.getAttributeHelper().hasAttribute(location, type)) {
            ItemStack itemStack = (ItemStack)((AttributeItemStack)cbTileEntity.getAttributeHelper().getAttribute(location, type)).getModel();
            Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
            IBlockState attrBlockState = BlockUtil.getAttributeBlockState(cbTileEntity.getAttributeHelper(), location, type);
            return ((IExtendedBlockState)blockState).withProperty(Property.ATTR_BLOCKSTATE, (Object)attrBlockState);
        }
        return blockState;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing facing, long rand) {
        if (!BlockUtil.validateBlockState(blockState) || facing != null) {
            return Collections.emptyList();
        }
        this._rand = rand;
        this._blockState = blockState;
        this._cbMetadata = (Integer)((IExtendedBlockState)blockState).getValue(Property.CB_METADATA);
        this._blockPos = (BlockPos)((IExtendedBlockState)blockState).getValue(Property.BLOCK_POS);
        this._renderFace = (Boolean[])((IExtendedBlockState)blockState).getValue(Property.RENDER_FACE);
        this._cbAttrHelper = new AttributeHelper((Map)((IExtendedBlockState)blockState).getValue(Property.ATTR_MAP));
        this._uncoveredRenderLayer = Minecraft.func_71410_x().field_71441_e.func_180495_p(this._blockPos).func_177230_c().func_180664_k();
        this._quadContainer = new QuadContainer(this._format, EnumAttributeLocation.HOST, false);
        boolean hasSideCoverYN = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.DOWN, EnumAttributeType.COVER);
        boolean hasSideCoverYP = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.UP, EnumAttributeType.COVER);
        boolean hasSideCoverZN = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.NORTH, EnumAttributeType.COVER);
        boolean hasSideCoverZP = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.SOUTH, EnumAttributeType.COVER);
        boolean hasSideCoverXN = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.WEST, EnumAttributeType.COVER);
        boolean hasSideCoverXP = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.EAST, EnumAttributeType.COVER);
        this._renderY = hasSideCoverZN || hasSideCoverZP || hasSideCoverXN || hasSideCoverXP;
        this._renderX = hasSideCoverYN || hasSideCoverYP || hasSideCoverZN || hasSideCoverZP;
        this._renderZ = hasSideCoverYN || hasSideCoverYP || hasSideCoverXN || hasSideCoverXP;
        this.fillQuads(this._quadContainer);
        return this.getQuads();
    }

    private List<BakedQuad> getQuads() {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        IBlockState hostBlockState = this._cbAttrHelper.hasAttribute(EnumAttributeLocation.HOST, EnumAttributeType.COVER) ? BlockUtil.getAttributeBlockState(this._cbAttrHelper, EnumAttributeLocation.HOST, EnumAttributeType.COVER) : null;
        EnumAttributeLocation[] enumAttributeLocationArray = EnumAttributeLocation.values();
        int n = enumAttributeLocationArray.length;
        for (int i = 0; i < n; ++i) {
            EnumAttributeLocation location;
            this._location = location = enumAttributeLocationArray[i];
            QuadContainer quadContainer = this._quadContainer;
            boolean hasCover = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.COVER);
            boolean bl = this._isSideCover = !EnumAttributeLocation.HOST.equals((Object)location);
            if (this._isSideCover && !hasCover) continue;
            boolean hasOverlay = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.OVERLAY);
            boolean hasChiselDesign = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.DESIGN_CHISEL);
            Map<EnumFacing, List<BakedQuad>> quadMap = this.getCoverQuads(quadContainer, location);
            boolean hasDye = this._cbAttrHelper.hasAttribute(location, EnumAttributeType.DYE);
            int dyeColor = !hasDye ? 0xFFFFFF : DyeHandler.getColor((ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.DYE)).getModel());
            IBlockState attributeState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, location, EnumAttributeType.COVER);
            if (!EnumAttributeLocation.HOST.equals((Object)location)) {
                this._sideDepth = this.isSnowState(attributeState) ? 0.125 : 0.0625;
                quadContainer = this._quadContainer.toSideLocation(location, this._sideDepth);
            }
            boolean canRenderCover = false;
            BlockRenderLayer outermostCoverRenderLayer = this._uncoveredRenderLayer;
            if (hasCover) {
                for (BlockRenderLayer layer : LAYERS) {
                    if (!attributeState.func_177230_c().canRenderInLayer(attributeState, layer)) continue;
                    if (layer.equals((Object)renderLayer)) {
                        canRenderCover = true;
                    }
                    outermostCoverRenderLayer = layer;
                }
            } else {
                canRenderCover = renderLayer.equals((Object)this._uncoveredRenderLayer);
            }
            BlockRenderLayer overlayRenderLayer = BlockRenderLayer.CUTOUT_MIPPED;
            if (hasOverlay) {
                overlayRenderLayer = BlockRenderLayer.TRANSLUCENT;
            } else if (LAYERS.indexOf(BlockRenderLayer.CUTOUT_MIPPED) < LAYERS.indexOf(outermostCoverRenderLayer)) {
                overlayRenderLayer = outermostCoverRenderLayer;
            }
            BlockRenderLayer chiselDesignRenderLayer = BlockRenderLayer.TRANSLUCENT;
            if (canRenderCover) {
                if (hasCover) {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        if (!quadMap.containsKey(facing)) continue;
                        for (BakedQuad bakedQuad : quadMap.get(facing)) {
                            int color;
                            int n2 = color = hasDye ? dyeColor : 0xFFFFFF;
                            if (!hasDye && bakedQuad.func_178212_b()) {
                                color = blockColors.func_186724_a(attributeState, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, this._blockPos, 0);
                            }
                            quads.addAll(this.getQuadsForSide(quadContainer, facing, bakedQuad.func_187508_a(), color));
                        }
                    }
                } else if (EnumAttributeLocation.HOST.equals((Object)location)) {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        quads.addAll(this.getQuadsForSide(quadContainer, facing, this.getUncoveredSprite(), dyeColor));
                    }
                }
            }
            if (hasChiselDesign && chiselDesignRenderLayer.equals((Object)renderLayer)) {
                String design = (String)((AttributeString)this._cbAttrHelper.getAttribute(location, EnumAttributeType.DESIGN_CHISEL)).getModel();
                TextureAtlasSprite chiselSprite = SpriteRegistry.sprite_design_chisel.get(DesignHandler.listChisel.indexOf(design));
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    quads.addAll(this.getQuadsForSide(quadContainer, facing, chiselSprite, 0xFFFFFF));
                }
            }
            if (hasOverlay && overlayRenderLayer.equals((Object)renderLayer)) {
                OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType((ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.OVERLAY)).getModel());
                int overlayColor = 0xFFFFFF;
                if (OverlayHandler.Overlay.GRASS.equals((Object)overlay)) {
                    IBlockState overlayBlockState = Blocks.field_150349_c.func_176223_P();
                    overlayColor = blockColors.func_186724_a(overlayBlockState, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, this._blockPos, ForgeHooksClient.getWorldRenderPass());
                }
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    TextureAtlasSprite overlaySprite = OverlayHandler.getOverlaySprite(overlay, facing);
                    if (overlaySprite == null) continue;
                    quads.addAll(this.getQuadsForSide(quadContainer, facing, overlaySprite, overlayColor));
                }
            }
            AbstractAttribute.Key upKey = AbstractAttribute.generateKey(EnumAttributeLocation.UP, EnumAttributeType.COVER);
            IBlockState upBlockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, upKey.getLocation(), upKey.getType());
            if (!EnumAttributeLocation.HOST.equals((Object)location) || !this._cbAttrHelper.hasAttribute(upKey) || !this.isSnowState(upBlockState) || hostBlockState == null || this.isSnowState(hostBlockState) || !overlayRenderLayer.equals((Object)renderLayer)) continue;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TextureAtlasSprite overlaySprite = OverlayHandler.getOverlaySprite(OverlayHandler.Overlay.SNOW, facing);
                if (overlaySprite == null) continue;
                quads.addAll(this.getQuadsForSide(quadContainer, facing, overlaySprite, 0xFFFFFF));
            }
        }
        return quads;
    }

    private boolean isSnowState(IBlockState blockState) {
        return blockState.func_177230_c().equals(Blocks.field_150433_aE) || blockState.func_177230_c().equals(Blocks.field_150431_aC);
    }

    private List<BakedQuad> getQuadsForSide(QuadContainer quadContainer, EnumFacing facing, TextureAtlasSprite sprite, int rgb) {
        return quadContainer.getBakedQuads(facing, sprite, rgb);
    }

    private Map<EnumFacing, List<BakedQuad>> getCoverQuads(QuadContainer quadContainer, EnumAttributeLocation location) {
        HashMap<EnumFacing, List<BakedQuad>> map;
        block3: {
            block2: {
                map = new HashMap<EnumFacing, List<BakedQuad>>();
                if (!this._cbAttrHelper.hasAttribute(location, EnumAttributeType.COVER)) break block2;
                ItemStack coverStack = (ItemStack)((AttributeItemStack)this._cbAttrHelper.getAttribute(location, EnumAttributeType.COVER)).getModel();
                if (coverStack == null) break block3;
                IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(coverStack);
                IBlockState blockState = BlockUtil.getAttributeBlockState(this._cbAttrHelper, location, EnumAttributeType.COVER);
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    map.put(facing, itemModel.func_188616_a(blockState, facing, this._rand));
                }
                break block3;
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                map.put(facing, this.getQuadsForSide(quadContainer, facing, this.getUncoveredSprite(), 0xFFFFFF));
            }
        }
        return map;
    }

    protected boolean canRenderSide(EnumFacing facing) {
        return true;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getUncoveredSprite();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public int getData() {
        return this._cbMetadata;
    }

    protected abstract void fillQuads(QuadContainer var1);

    protected abstract TextureAtlasSprite getUncoveredSprite();
}

