/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.UV;
import com.carpentersblocks.renderer.VecUtil;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class QuadContainer {
    private static final String GRASS_SIDE_OVERLAY = "minecraft:blocks/grass_side_overlay";
    private List<Quad> _quads = new ArrayList<Quad>();
    private VertexFormat _format;
    private boolean _sideCover;
    private EnumAttributeLocation _location;

    public QuadContainer(VertexFormat format, EnumAttributeLocation location, boolean sideCover) {
        this._format = format;
        this._sideCover = sideCover;
        this._location = location;
    }

    public List<Quad> getQuads(EnumFacing facing) {
        ArrayList<Quad> quads = new ArrayList<Quad>();
        for (Quad quad : this._quads) {
            if (!facing.equals((Object)quad.getFacing())) continue;
            quads.add(quad);
        }
        return quads;
    }

    public void add(Quad quad) {
        if (VecUtil.isValid(quad)) {
            this._quads.add(quad);
        }
    }

    public QuadContainer toSideLocation(EnumAttributeLocation location, double depth) {
        QuadContainer quadContainer = new QuadContainer(this._format, location, true);
        EnumFacing facing = EnumFacing.func_82600_a((int)location.ordinal());
        List<Quad> quads = this.getQuads(facing);
        for (Quad quad : quads) {
            Quad sideQuad = Quad.getQuad(facing, quad.getVecs());
            if (sideQuad == null) continue;
            quadContainer.add(sideQuad.offset((double)facing.func_82601_c() * depth, (double)facing.func_96559_d() * depth, (double)facing.func_82599_e() * depth));
            for (Quad perpQuad : VecUtil.getPerpendicularQuads(quad, depth)) {
                quadContainer.add(perpQuad);
            }
        }
        return quadContainer;
    }

    public List<BakedQuad> getBakedQuads(EnumFacing facing, TextureAtlasSprite sprite, int rgb) {
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (Quad quad : this._quads) {
            if (!facing.equals((Object)quad.getFacing())) continue;
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this._format);
            builder.setTexture(sprite);
            Vec3d normal = VecUtil.getNormal(quad);
            boolean floatY = sprite.func_94215_i().equals(GRASS_SIDE_OVERLAY) || sprite.func_94215_i().contains("overlay/overlay_") && sprite.func_94215_i().endsWith("_side");
            UV[] uv = VecUtil.getUV(quad, floatY, this._location);
            Vec3d[] vecs = quad.getVecs();
            this.putVertex(builder, normal, vecs[0].field_72450_a, vecs[0].field_72448_b, vecs[0].field_72449_c, uv[0].getU(), uv[0].getV(), sprite, rgb);
            this.putVertex(builder, normal, vecs[1].field_72450_a, vecs[1].field_72448_b, vecs[1].field_72449_c, uv[1].getU(), uv[1].getV(), sprite, rgb);
            this.putVertex(builder, normal, vecs[2].field_72450_a, vecs[2].field_72448_b, vecs[2].field_72449_c, uv[2].getU(), uv[2].getV(), sprite, rgb);
            this.putVertex(builder, normal, vecs[3].field_72450_a, vecs[3].field_72448_b, vecs[3].field_72449_c, uv[3].getU(), uv[3].getV(), sprite, rgb);
            list.add((BakedQuad)builder.build());
        }
        return list;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, int rgb) {
        block6: for (int idx = 0; idx < this._format.func_177345_h(); ++idx) {
            switch (this._format.func_177348_c(idx).func_177375_c()) {
                case POSITION: {
                    builder.put(idx, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(idx, new float[]{(float)((rgb & 0xFF0000) >>> 16) / 255.0f, (float)((rgb & 0xFF00) >>> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this._format.func_177348_c(idx).func_177369_e() != 0) continue block6;
                    builder.put(idx, new float[]{sprite.func_94214_a((double)u), sprite.func_94207_b((double)v), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(idx, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(idx, new float[0]);
                }
            }
        }
    }
}

