/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.block;

import com.carpentersblocks.api.IWrappableBlock;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.attribute.AbstractAttribute;
import com.carpentersblocks.util.attribute.AttributeHelper;
import com.carpentersblocks.util.attribute.AttributeItemStack;
import com.carpentersblocks.util.attribute.EnumAttributeLocation;
import com.carpentersblocks.util.attribute.EnumAttributeType;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.oredict.OreDictionary;

public class BlockUtil {
    public static Block toBlock(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock) {
            return Block.func_149634_a((Item)itemStack.func_77973_b());
        }
        return Blocks.field_150350_a;
    }

    public static boolean validateBlockState(IBlockState blockState) {
        return blockState != null && blockState instanceof IExtendedBlockState && ((IExtendedBlockState)blockState).getUnlistedProperties().containsKey(Property.CB_METADATA) && ((IExtendedBlockState)blockState).getValue(Property.CB_METADATA) != null;
    }

    public static IBlockState getAttributeBlockState(AttributeHelper helper, AbstractAttribute attribute) {
        return BlockUtil.getAttributeBlockState(helper, attribute.getLocation(), attribute.getType());
    }

    public static IBlockState getAttributeBlockState(AttributeHelper helper, EnumAttributeLocation location, EnumAttributeType type) {
        AbstractAttribute attribute;
        if (helper.hasAttribute(location, type) && (attribute = helper.getAttribute(location, type)) instanceof AttributeItemStack) {
            ItemStack itemStack = (ItemStack)((AttributeItemStack)attribute).getModel();
            return BlockUtil.getBlockState(itemStack);
        }
        return null;
    }

    public static IBlockState getBlockState(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        return block != null ? block.func_176203_a(itemStack.func_77960_j()) : null;
    }

    public static ItemStack getCallableItemStack(ItemStack itemStack) {
        IBlockState blockState = BlockUtil.getBlockState(itemStack);
        if (blockState.func_177230_c() instanceof BlockCoverable || blockState.func_177230_c() instanceof IWrappableBlock) {
            return itemStack;
        }
        return blockState.func_177230_c().hasTileEntity(blockState) ? new ItemStack(Blocks.field_150344_f) : itemStack;
    }

    public static ItemStack getCover(CbTileEntity cbTileEntity, EnumAttributeLocation location) {
        ItemStack itemStack = BlockUtil.getCoverSafe(cbTileEntity, location);
        return BlockUtil.getCallableItemStack(itemStack);
    }

    public static ItemStack getCoverSafe(CbTileEntity cbTileEntity, EnumAttributeLocation location) {
        ItemStack itemStack = (ItemStack)((AttributeItemStack)cbTileEntity.getAttributeHelper().getAttribute(location, EnumAttributeType.COVER)).getModel();
        return itemStack != null ? itemStack : new ItemStack(cbTileEntity.func_145838_q());
    }

    public static EnumAttributeLocation getAttributeLocationForFacing(CbTileEntity cbTileEntity, EnumFacing facing) {
        return cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.valueOf(facing.ordinal()), EnumAttributeType.COVER) ? EnumAttributeLocation.valueOf(facing.ordinal()) : EnumAttributeLocation.HOST;
    }

    public static ItemStack getFeatureSensitiveSideItemStack(CbTileEntity cbTileEntity, EnumFacing facing) {
        OverlayHandler.Overlay overlay;
        EnumAttributeLocation location;
        ItemStack itemStack = null;
        EnumAttributeLocation enumAttributeLocation = location = cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.valueOf(facing.ordinal()), EnumAttributeType.COVER) ? EnumAttributeLocation.valueOf(facing.ordinal()) : EnumAttributeLocation.HOST;
        if (cbTileEntity.getAttributeHelper().hasAttribute(EnumAttributeLocation.valueOf(facing.ordinal()), EnumAttributeType.OVERLAY) && OverlayHandler.coversFullSide(overlay = OverlayHandler.getOverlayType((ItemStack)((AttributeItemStack)cbTileEntity.getAttributeHelper().getAttribute(location, EnumAttributeType.OVERLAY)).getModel()), facing)) {
            itemStack = overlay.getItemStack();
        }
        if (itemStack == null) {
            itemStack = BlockUtil.getCover(cbTileEntity, location);
        }
        return itemStack;
    }

    public static TextureAtlasSprite getParticleTexture(ItemStack itemStack) {
        IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(itemStack);
        return itemModel.func_177554_e();
    }

    public static boolean isCover(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemBlock && !BlockUtil.isOverlay(itemStack)) {
            IBlockState blockState;
            Block block = BlockUtil.toBlock(itemStack);
            return block.func_149686_d(blockState = block.func_176203_a(itemStack.func_77952_i())) || block instanceof BlockSlab || block instanceof BlockPane || block instanceof BlockBreakable || FeatureRegistry.coverExceptions.contains(itemStack.func_82833_r()) || FeatureRegistry.coverExceptions.contains(ChatHandler.getDefaultTranslation(itemStack));
        }
        return false;
    }

    public static boolean isIlluminator(ItemStack itemStack) {
        if (itemStack != null) {
            for (int Id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                if (!OreDictionary.getOreName((int)Id).equals("dustGlowstone")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDye(ItemStack itemStack, boolean allowWhite) {
        return itemStack.func_77973_b() != null && DyeHandler.isDye(itemStack, allowWhite);
    }

    public static boolean isOverlay(ItemStack itemStack) {
        return OverlayHandler.overlayMap.containsKey(itemStack.func_82833_r()) || OverlayHandler.overlayMap.containsKey(ChatHandler.getDefaultTranslation(itemStack));
    }

    public static String getOreDictMatch(ItemStack itemStack, String ... name) {
        if (itemStack != null) {
            for (int Id : OreDictionary.getOreIDs((ItemStack)itemStack)) {
                for (String oreName : name) {
                    if (!OreDictionary.getOreName((int)Id).equals(oreName)) continue;
                    return oreName;
                }
            }
        }
        return "";
    }
}

