/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.block.BlockUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static EnumFacing eventFace;
    public static EnumHand eventHand;
    public static Vec3d eventHitVector;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
    }

    private boolean isValidBlockEvent(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null && tileEntity instanceof CbTileEntity;
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (this.isValidBlockEvent(event.getWorld(), event.getPos())) {
            boolean hasTool;
            ItemStack itemStack = event.getPlayer().func_184614_ca();
            boolean bl = hasTool = itemStack != null && (itemStack.func_77973_b() instanceof ICarpentersHammer || itemStack.func_77973_b() instanceof ICarpentersChisel);
            if (hasTool && event.getPlayer().field_71075_bZ.field_75098_d) {
                event.setCanceled(true);
            }
        }
    }

    private Vec3d getNormalizedHitVec(Vec3d vec, BlockPos pos) {
        double x = Math.abs(vec.field_72450_a - (double)pos.func_177958_n());
        double y = Math.abs(vec.field_72448_b - (double)pos.func_177956_o());
        double z = Math.abs(vec.field_72449_c - (double)pos.func_177952_p());
        return new Vec3d(x, y, z);
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (this.isValidBlockEvent(event.getWorld(), event.getPos())) {
            boolean hasTool;
            eventFace = event.getFace();
            eventHand = event.getHand();
            eventHitVector = this.getNormalizedHitVec(event.getHitVec(), event.getPos());
            ItemStack itemStack = event.getEntityPlayer().func_184586_b(event.getHand());
            boolean bl = hasTool = itemStack != null && (itemStack.func_77973_b() instanceof ICarpentersHammer || itemStack.func_77973_b() instanceof ICarpentersChisel);
            if (hasTool && event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                IBlockState blockState = event.getEntityPlayer().func_130014_f_().func_180495_p(event.getPos());
                blockState.func_177230_c().func_180649_a(event.getEntityPlayer().func_130014_f_(), event.getPos(), event.getEntityPlayer());
                if (event.getWorld().field_72995_K) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.isValidBlockEvent(event.getWorld(), event.getPos())) {
            eventFace = event.getFace();
            eventHand = event.getHand();
            eventHitVector = this.getNormalizedHitVec(event.getHitVec(), event.getPos());
            ItemStack itemStack = event.getEntityPlayer().func_184586_b(event.getHand());
            if (event.getEntityPlayer().func_70093_af() && (itemStack == null || !(itemStack.func_77973_b() instanceof ItemBlock) || BlockUtil.isOverlay(itemStack))) {
                IBlockState blockState = event.getWorld().func_180495_p(event.getPos());
                blockState.func_177230_c().func_180639_a(event.getEntityPlayer().field_70170_p, event.getPos(), blockState, event.getEntityPlayer(), EnumHand.MAIN_HAND, event.getEntityPlayer().func_184614_ca(), event.getFace(), 1.0f, 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        EntityPlayerSP entityPlayer;
        if (event.getButton() < 0 && (entityPlayer = Minecraft.func_71410_x().field_71439_g) != null && entityPlayer.func_70093_af()) {
            ItemStack itemStack = entityPlayer.func_184614_ca();
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        World world = entityLivingBase.field_70170_p;
    }

    private CbTileEntity getApproximateSoundOrigin(World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity != null && tileEntity instanceof CbTileEntity) {
            return (CbTileEntity)tileEntity;
        }
        TileEntity TE_YN = world.func_175625_s(blockPos.func_177982_a(0, -1, 0));
        if (TE_YN != null && TE_YN instanceof CbTileEntity) {
            return (CbTileEntity)TE_YN;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
    }

    private CbTileEntity getTileEntityAtFeet(Entity entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        TileEntity tileEntity = entity.field_70170_p.func_175625_s(new BlockPos(x, y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - entity.func_70033_W())), z = MathHelper.func_76128_c((double)entity.field_70161_v)));
        if (tileEntity != null && tileEntity instanceof CbTileEntity) {
            return (CbTileEntity)tileEntity;
        }
        return null;
    }

    private boolean isMovingOnGround(Entity entity) {
        return entity.field_70122_E && (entity.field_70159_w != 0.0 || entity.field_70179_y != 0.0);
    }
}

