/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.io.File;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.puffish.castle.BlockMeta;
import net.puffish.castle.ForgeBlockParser;
import net.puffish.castle.ForgeGenerator;
import net.puffish.castle.ForgeItemParser;
import net.puffish.castle.ItemMeta;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.Configuration;
import net.puffish.castle.config.chest.Chest;
import net.puffish.castle.config.chest.ChestItem;
import net.puffish.castle.config.theme.Theme;

@Mod(modid="castle_dungeons", name="Castle Dungeons", version="1.3", acceptableRemoteVersions="*")
public class CastleDungeons {
    public static final String MOD_ID = "castle_dungeons";
    public static final ResourceLocation LOOT_TABLE_LOOT = new ResourceLocation("castle_dungeons", "chests/loot");
    public static final ResourceLocation LOOT_TABLE_HEAL = new ResourceLocation("castle_dungeons", "chests/heal");
    public static final ResourceLocation LOOT_TABLE_JUNK = new ResourceLocation("castle_dungeons", "chests/junk");
    private ForgeGenerator generator;
    private File configDirectory;
    private static final String[] files = new String[]{"themes/default.cfg", "themes/desert.cfg", "chests.cfg", "config.cfg"};
    private List<Theme<BlockMeta>> themes;
    private Chest<ItemMeta> chest;
    private Config config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDirectory = new File(event.getModConfigurationDirectory(), "castle_dungeons/");
        if (!this.configDirectory.exists()) {
            this.configDirectory.mkdirs();
            Configuration.copyDefaultConfig(this.configDirectory, files);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.themes = Configuration.loadThemes(this.configDirectory, new ForgeBlockParser());
        this.chest = Configuration.loadChest(this.configDirectory, new ForgeItemParser());
        this.config = Configuration.loadConfig(this.configDirectory);
        System.out.println("Themes loaded: " + String.valueOf(this.themes.size()));
        System.out.println("Chests loaded: " + String.valueOf(this.chest != null));
        System.out.println("Config loaded: " + String.valueOf(this.config != null));
        if (this.config != null) {
            this.generator.setConfig(this.config.getMaxY(), this.config.getMinY(), this.config.getMaxFoundationThickness(), this.config.getSectionSize(), this.config.getMaxCastleSize(), this.config.getMinCastleSize());
        }
        LootTableList.func_186375_a((ResourceLocation)LOOT_TABLE_LOOT);
        LootTableList.func_186375_a((ResourceLocation)LOOT_TABLE_HEAL);
        LootTableList.func_186375_a((ResourceLocation)LOOT_TABLE_JUNK);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (this.chest == null) {
            return;
        }
        ResourceLocation rl = event.getName();
        List<ChestItem<ItemMeta>> list = null;
        int percent = 0;
        if (LOOT_TABLE_LOOT.equals((Object)rl)) {
            list = this.chest.getLootItems();
            percent = this.chest.getLootPercent();
        } else if (LOOT_TABLE_HEAL.equals((Object)rl)) {
            list = this.chest.getHealItems();
            percent = this.chest.getHealPercent();
        } else if (LOOT_TABLE_JUNK.equals((Object)rl)) {
            list = this.chest.getJunkItems();
            percent = this.chest.getJunkPercent();
        }
        if (list != null) {
            int count = (int)Math.floor(27.0 * (double)percent / 100.0);
            LootTable table = event.getTable();
            LootEntry[] entries = new LootEntry[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ChestItem<ItemMeta> item = list.get(i);
                LootFunction[] functions = item.getItem().getMeta() != 0 ? new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange((float)item.getMin(), (float)item.getMax())), new SetMetadata(new LootCondition[0], new RandomValueRange((float)item.getItem().getMeta()))} : new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange((float)item.getMin(), (float)item.getMax()))};
                entries[i] = new LootEntryItem(item.getItem().getItem(), item.getWeight(), 0, functions, new LootCondition[0], "");
            }
            LootPool pool = new LootPool(entries, new LootCondition[0], new RandomValueRange((float)count), new RandomValueRange(0.0f), "");
            table.addPool(pool);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.generator = new ForgeGenerator(this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.generator, (int)0);
    }

    public List<Theme<BlockMeta>> getThemes() {
        return this.themes;
    }

    public Chest<ItemMeta> getChest() {
        return this.chest;
    }

    public Config getConfig() {
        return this.config;
    }
}

