/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.ForgeWorldEditor;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.Generator;
import net.puffish.castle.builder.GroundType;
import net.puffish.castle.builder.WorldEditor;

public class ForgeGenerator
extends Generator
implements IWorldGenerator {
    private CastleDungeons castleDungeons;
    private static List<Material> invalid = Arrays.asList(Material.field_151575_d, Material.field_151585_k, Material.field_151584_j, Material.field_151597_y, Material.field_151577_b, Material.field_151572_C, Material.field_151570_A, Material.field_151588_w);
    private static List<Material> liquid = Arrays.asList(Material.field_151586_h, Material.field_151587_i);

    public ForgeGenerator(CastleDungeons castleDungeons) {
        this.castleDungeons = castleDungeons;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        this.generate(random, chunkX, chunkZ, world.func_72905_C(), new ForgeWorldEditor(this.castleDungeons, world, random));
    }

    @Override
    public GroundType getGroundType(WorldEditor editor, Coord coord) {
        BlockPos pos;
        World world = ((ForgeWorldEditor)editor).getWorld();
        if (world.func_175623_d(pos = this.coordToBlockPos(coord))) {
            return GroundType.INVALID;
        }
        if (liquid.contains(world.func_180495_p(pos).func_185904_a())) {
            return GroundType.LIQUID;
        }
        if (invalid.contains(world.func_180495_p(pos).func_185904_a())) {
            return GroundType.INVALID;
        }
        return GroundType.VALID;
    }

    private BlockPos coordToBlockPos(Coord coord) {
        return new BlockPos(coord.getX(), coord.getY(), coord.getZ());
    }
}

