/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDoor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.puffish.castle.BlockMeta;
import net.puffish.castle.CastleDungeons;
import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.MonsterType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.config.theme.Theme;

public class ForgeWorldEditor
extends WorldEditor {
    private World world;
    private Theme<BlockMeta> theme;
    private CastleDungeons castleDungeons;
    private Random random;

    public ForgeWorldEditor(CastleDungeons castleDungeons, World world, Random random) {
        this.random = random;
        this.castleDungeons = castleDungeons;
        this.world = world;
    }

    @Override
    public boolean chooseTheme(Coord coord) {
        Biome biome = this.world.func_180494_b(new BlockPos(coord.getX(), coord.getY(), coord.getZ()));
        String biomeName = biome.getRegistryName().func_110624_b() + ":" + biome.getRegistryName().func_110623_a();
        ArrayList<Theme<BlockMeta>> matchingThemes = new ArrayList<Theme<BlockMeta>>();
        for (Theme<BlockMeta> t : this.castleDungeons.getThemes()) {
            if (t.getBiomeWhitelist() != null) {
                if (!t.getBiomeWhitelist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            if (t.getBiomeBlacklist() != null) {
                if (t.getBiomeBlacklist().contains(biomeName)) continue;
                matchingThemes.add(t);
                continue;
            }
            matchingThemes.add(t);
        }
        if (matchingThemes.isEmpty()) {
            return true;
        }
        this.theme = (Theme)matchingThemes.get(this.random.nextInt(matchingThemes.size()));
        return false;
    }

    @Override
    public void setBlockIfEmpty(Coord coord, BlockType type) {
        if (!this.world.func_180495_p(new BlockPos(coord.getX(), coord.getY(), coord.getZ())).func_185914_p()) {
            this.setBlock(coord, type);
        }
    }

    private void placeBed(Coord coord, Random random, EnumFacing facing) {
        try {
            EnumDyeColor color = EnumDyeColor.values()[random.nextInt(EnumDyeColor.values().length)];
            IBlockState state = Blocks.field_150324_C.func_176223_P();
            state = state.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
            state = state.func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)facing);
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.func_175656_a(pos, state);
            TileEntityBed bed = (TileEntityBed)this.world.func_175625_s(pos);
            bed.func_193052_a(color);
            pos = pos.func_177972_a(facing.func_176734_d());
            state = Blocks.field_150324_C.func_176223_P();
            state = state.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
            state = state.func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)facing);
            this.world.func_175656_a(pos, state);
            bed = (TileEntityBed)this.world.func_175625_s(pos);
            bed.func_193052_a(color);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing bed");
        }
    }

    private void placeDoor(Coord coord, EnumFacing facing) {
        try {
            ItemDoor.func_179235_a((World)this.world, (BlockPos)new BlockPos(coord.getX(), coord.getY(), coord.getZ()), (EnumFacing)facing, (Block)this.getRandom(this.theme.getDoorBlocks(), this.random).getBlock(), (boolean)false);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing door");
        }
    }

    @Override
    public void setBlock(Coord coord, BlockType type) {
        try {
            switch (type) {
                case BED_NEGATIVE_X: {
                    this.placeBed(coord, this.random, EnumFacing.EAST);
                    break;
                }
                case BED_NEGATIVE_Z: {
                    this.placeBed(coord, this.random, EnumFacing.SOUTH);
                    break;
                }
                case BED_POSITIVE_X: {
                    this.placeBed(coord, this.random, EnumFacing.WEST);
                    break;
                }
                case BED_POSITIVE_Z: {
                    this.placeBed(coord, this.random, EnumFacing.NORTH);
                    break;
                }
                case DOOR_X: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150350_a, 0));
                    this.setBlock(Coord.add(coord, 0, 1, 0), new BlockMeta(Blocks.field_150350_a, 0));
                    if (this.random.nextInt(2) == 0) {
                        this.placeDoor(coord, EnumFacing.EAST);
                        break;
                    }
                    this.placeDoor(coord, EnumFacing.WEST);
                    break;
                }
                case DOOR_Y: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150350_a, 0));
                    this.setBlock(Coord.add(coord, 0, 1, 0), new BlockMeta(Blocks.field_150350_a, 0));
                    if (this.random.nextInt(2) == 0) {
                        this.placeDoor(coord, EnumFacing.SOUTH);
                        break;
                    }
                    this.placeDoor(coord, EnumFacing.NORTH);
                    break;
                }
                case WALL: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallBlocks(), this.random));
                    break;
                }
                case WALL_FRAME: {
                    this.setBlock(coord, this.getRandom(this.theme.getWallFrameBlocks(), this.random));
                    break;
                }
                case FLOOR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor0Blocks(), this.random));
                    break;
                }
                case FLOOR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFloor1Blocks(), this.random));
                    break;
                }
                case PILLAR_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar0Blocks(), this.random));
                    break;
                }
                case PILLAR_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getPillar1Blocks(), this.random));
                    break;
                }
                case FENCE_0: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence0Blocks(), this.random));
                    break;
                }
                case FENCE_1: {
                    this.setBlock(coord, this.getRandom(this.theme.getFence1Blocks(), this.random));
                    break;
                }
                case ROOF_NEGATIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.EAST, BlockStairs.EnumShape.STRAIGHT);
                    break;
                }
                case ROOF_NEGATIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.SOUTH, BlockStairs.EnumShape.OUTER_LEFT);
                    break;
                }
                case ROOF_NEGATIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.NORTH, BlockStairs.EnumShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.SOUTH, BlockStairs.EnumShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.WEST, BlockStairs.EnumShape.STRAIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_NEGATIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.SOUTH, BlockStairs.EnumShape.OUTER_RIGHT);
                    break;
                }
                case ROOF_POSITIVE_X_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.NORTH, BlockStairs.EnumShape.OUTER_LEFT);
                    break;
                }
                case ROOF_POSITIVE_Z: {
                    this.setStairsBlock(coord, this.getRandom(this.theme.getRoofStairsBlocks(), this.random), EnumFacing.NORTH, BlockStairs.EnumShape.STRAIGHT);
                    break;
                }
                case ROOF_TOP: {
                    this.setBlock(coord, this.getRandom(this.theme.getRoofSlabBlocks(), this.random));
                    break;
                }
                case STAIRS_0: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), this.random), BlockSlab.EnumBlockHalf.BOTTOM);
                    break;
                }
                case STAIRS_1: {
                    this.setSlabBlock(coord, this.getRandom(this.theme.getSpiralStairsBlocks(), this.random), BlockSlab.EnumBlockHalf.TOP);
                    break;
                }
                case WINDOW: {
                    this.setBlock(coord, this.getRandom(this.theme.getWindowBlocks(), this.random));
                    break;
                }
                case CEIL: {
                    this.setBlock(coord, this.getRandom(this.theme.getCeilBlocks(), this.random));
                    break;
                }
                case FOUNDATION: {
                    this.setBlock(coord, this.getRandom(this.theme.getFoundationBlocks(), this.random));
                    break;
                }
                case FURNACE_NEGATIVE_X: {
                    this.setFurnaceBlock(coord, new BlockMeta(Blocks.field_150460_al, 0), EnumFacing.EAST);
                    break;
                }
                case FURNACE_NEGATIVE_Z: {
                    this.setFurnaceBlock(coord, new BlockMeta(Blocks.field_150460_al, 0), EnumFacing.SOUTH);
                    break;
                }
                case FURNACE_POSITIVE_X: {
                    this.setFurnaceBlock(coord, new BlockMeta(Blocks.field_150460_al, 0), EnumFacing.WEST);
                    break;
                }
                case FURNACE_POSITIVE_Z: {
                    this.setFurnaceBlock(coord, new BlockMeta(Blocks.field_150460_al, 0), EnumFacing.NORTH);
                    break;
                }
                case ANVIL: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150467_bQ, 0));
                    break;
                }
                case COAL: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150402_ci, 0));
                    break;
                }
                case TNT: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150335_W, 0));
                    break;
                }
                case FOOD: {
                    if (this.random.nextInt(2) == 0) {
                        this.setBlock(coord, new BlockMeta(Blocks.field_150440_ba, 0));
                        break;
                    }
                    this.setBlock(coord, new BlockMeta(Blocks.field_150423_aK, 0));
                    break;
                }
                case BOOKSHELF: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150342_X, 0));
                    break;
                }
                case ENCHANTING_TABLE: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150381_bn, 0));
                    break;
                }
                case HAY: {
                    this.setBlock(coord, new BlockMeta(Blocks.field_150407_cf, 0));
                    break;
                }
                case EMPTY: {
                    this.world.func_175698_g(new BlockPos(coord.getX(), coord.getY(), coord.getZ()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BlockMeta getRandom(List<BlockMeta> blocks, Random random) {
        return blocks.get(random.nextInt(blocks.size()));
    }

    public void setBlock(Coord coord, BlockMeta blockMeta) {
        this.world.func_175656_a(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), blockMeta.getBlock().func_176203_a(blockMeta.getMeta()));
    }

    public void setFurnaceBlock(Coord coord, BlockMeta blockMeta, EnumFacing facing) {
        try {
            IBlockState state = blockMeta.getBlock().func_176203_a(blockMeta.getMeta());
            state = state.func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)facing);
            this.world.func_175656_a(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing furnace");
        }
    }

    public void setStairsBlock(Coord coord, BlockMeta blockMeta, EnumFacing facing, BlockStairs.EnumShape shape) {
        try {
            IBlockState state = blockMeta.getBlock().func_176203_a(blockMeta.getMeta());
            state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing);
            state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)shape);
            this.world.func_175656_a(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing stairs");
        }
    }

    public void setSlabBlock(Coord coord, BlockMeta blockMeta, BlockSlab.EnumBlockHalf half) {
        try {
            IBlockState state = blockMeta.getBlock().func_176203_a(blockMeta.getMeta());
            state = state.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)half);
            this.world.func_175656_a(new BlockPos(coord.getX(), coord.getY(), coord.getZ()), state);
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing slab");
        }
    }

    @Override
    public void setChest(Coord coord, ChestType type) {
        try {
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
            if (this.castleDungeons.getChest() == null) {
                return;
            }
            TileEntityChest chest = (TileEntityChest)this.world.func_175625_s(pos);
            switch (type) {
                case LOOT: {
                    chest.func_189404_a(CastleDungeons.LOOT_TABLE_LOOT, 0L);
                    break;
                }
                case HEAL: {
                    chest.func_189404_a(CastleDungeons.LOOT_TABLE_HEAL, 0L);
                    break;
                }
                case JUNK: {
                    chest.func_189404_a(CastleDungeons.LOOT_TABLE_JUNK, 0L);
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing chest");
        }
    }

    @Override
    public void setSpawner(Coord coord, MonsterType type) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            switch (type) {
                case HARD: {
                    list.addAll(this.theme.getMobsHard());
                }
                case MEDIUM: {
                    list.addAll(this.theme.getMobsMedium());
                }
                case EASY: {
                    list.addAll(this.theme.getMobsEasy());
                }
            }
            String mob = (String)list.get(this.random.nextInt(list.size()));
            BlockPos pos = new BlockPos(coord.getX(), coord.getY(), coord.getZ());
            this.world.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.world.func_175625_s(pos);
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            NBTTagCompound spawnData = new NBTTagCompound();
            spawnData.func_74778_a("id", mob);
            logic.func_184993_a(new WeightedSpawnerEntity(1, spawnData));
        }
        catch (Exception e) {
            System.out.println("An error occurred while placing spawner");
        }
    }

    public World getWorld() {
        return this.world;
    }
}

