/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import java.util.Random;
import net.puffish.castle.builder.Builder;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.GroundType;
import net.puffish.castle.builder.Measure;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.rooms.BedRoom;
import net.puffish.castle.builder.rooms.BlacksmithRoom;
import net.puffish.castle.builder.rooms.LibraryRoom;
import net.puffish.castle.builder.rooms.StorageRoom;
import net.puffish.castle.generator.Castle;

public class Generator {
    private int MAX_Y = 128;
    private int MIN_Y = 16;
    private int MAX_FOUNDATION_THICKNESS = 12;
    private int SECTION_SIZE = 24;
    private int MAX_CASTLE_SIZE = 8;
    private int MIN_CASTLE_SIZE = 6;

    public void setConfig(int maxY, int minY, int maxFoundationThickness, int sectionSize, int maxCastleSize, int minCastleSize) {
        this.MAX_Y = maxY;
        this.MIN_Y = minY;
        this.MAX_FOUNDATION_THICKNESS = maxFoundationThickness;
        this.SECTION_SIZE = sectionSize;
        this.MAX_CASTLE_SIZE = maxCastleSize;
        this.MIN_CASTLE_SIZE = minCastleSize;
    }

    public void generate(Random random, int chunkX, int chunkZ, long worldSeed, WorldEditor editor) {
        if (!this.checkChunk(worldSeed, chunkX, chunkZ)) {
            return;
        }
        int x = random.nextInt(16) + chunkX * 16;
        int z = random.nextInt(16) + chunkZ * 16;
        int w = random.nextInt(this.MAX_CASTLE_SIZE - this.MIN_CASTLE_SIZE + 1) + this.MIN_CASTLE_SIZE;
        int h = random.nextInt(this.MAX_CASTLE_SIZE - this.MIN_CASTLE_SIZE + 1) + this.MIN_CASTLE_SIZE;
        Coord coord = new Coord(x, 0, z);
        if (editor.chooseTheme(this.findGroudCoord(editor, x, z))) {
            return;
        }
        Castle castle = new Castle(w, h);
        castle.addRoom(new LibraryRoom(0, 1));
        castle.addRoom(new BlacksmithRoom(0, 2));
        castle.addRoom(new BedRoom(0, 6));
        castle.addRoom(new StorageRoom(0, 10));
        castle.generate(random);
        if (!castle.isValid()) {
            return;
        }
        Measure measure = new Measure(coord, castle);
        measure.center();
        int[] y2 = this.findMinMaxY(measure, editor, measure.getMinX(), measure.getMinZ());
        if (y2 == null) {
            return;
        }
        int minY = y2[0];
        int maxY = y2[1];
        if (maxY < this.MIN_Y) {
            return;
        }
        if (maxY - minY > this.MAX_FOUNDATION_THICKNESS) {
            return;
        }
        Coord buildCoord = measure.getCoord();
        buildCoord.setY(maxY);
        Builder builder = new Builder(editor);
        builder.buildCastle(buildCoord, castle, random);
        builder.buildFundation(buildCoord, measure.getWidth(), measure.getHeight(), this.MAX_FOUNDATION_THICKNESS);
    }

    private boolean checkChunk(long worldSeed, int chunkX, int chunkZ) {
        int sectorX = chunkX / this.SECTION_SIZE;
        int sectorZ = chunkZ / this.SECTION_SIZE;
        long seed = (long)sectorX << 32 | (long)sectorZ & 0xFFFFFFFFL;
        Random random = new Random(seed ^= worldSeed);
        int targetX = random.nextInt(this.SECTION_SIZE);
        int targetZ = random.nextInt(this.SECTION_SIZE);
        return (chunkX + targetX) % this.SECTION_SIZE == 0 && (chunkZ + targetZ) % this.SECTION_SIZE == 0;
    }

    private Coord findGroudCoord(WorldEditor editor, int x, int z) {
        Coord coord = new Coord(x, this.MAX_Y, z);
        while (coord.getY() >= 0 && this.getGroundType(editor, coord) != GroundType.VALID) {
            coord.add(0, -1, 0);
        }
        return coord;
    }

    private int[] findMinMaxY(Measure measure, WorldEditor editor, int x, int z) {
        int min = this.MAX_Y;
        int max = 0;
        for (int i = 0; i < measure.getWidth(); ++i) {
            block1: for (int j = 0; j < measure.getHeight(); ++j) {
                Coord coord = new Coord(x + i, this.MAX_Y, z + j);
                while (coord.getY() >= 0) {
                    GroundType ground = this.getGroundType(editor, coord);
                    if (ground == GroundType.LIQUID) {
                        max = Math.max(max, coord.getY());
                    }
                    if (ground == GroundType.VALID) {
                        min = Math.min(min, coord.getY());
                        max = Math.max(max, coord.getY());
                        continue block1;
                    }
                    coord.add(0, -1, 0);
                }
            }
        }
        return new int[]{min, max};
    }

    public GroundType getGroundType(WorldEditor editor, Coord coord) {
        return GroundType.INVALID;
    }
}

