/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.MonsterType;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.generator.Rotation;

public class RotatedWorldEditor
extends WorldEditor {
    private WorldEditor editor;
    private Coord coord;
    private int width;
    private int height;
    private Rotation rotation;

    public RotatedWorldEditor(WorldEditor editor, Coord coord, int width, int height, Rotation rotation) {
        this.editor = editor;
        this.coord = coord;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
    }

    private Coord convert(Coord coord) {
        switch (this.rotation) {
            case DEGREES_0: {
                return new Coord(this.coord.getX() + coord.getX() - 2, this.coord.getY() + coord.getY(), this.coord.getZ() + coord.getZ() - 2);
            }
            case DEGREES_90: {
                return new Coord(this.coord.getX() + this.height - 1 - coord.getZ() - 2, this.coord.getY() + coord.getY(), this.coord.getZ() + coord.getX() - 2);
            }
            case DEGREES_180: {
                return new Coord(this.coord.getX() + this.width - 1 - coord.getX() - 2, this.coord.getY() + coord.getY(), this.coord.getZ() + this.height - 1 - coord.getZ() - 2);
            }
            case DEGREES_270: {
                return new Coord(this.coord.getX() + coord.getZ() - 2, this.coord.getY() + coord.getY(), this.coord.getZ() + this.width - 1 - coord.getX() - 2);
            }
        }
        return null;
    }

    @Override
    public boolean chooseTheme(Coord coord) {
        return this.editor.chooseTheme(coord);
    }

    @Override
    public void setBlockIfEmpty(Coord coord, BlockType type) {
        this.editor.setBlockIfEmpty(this.convert(coord), type);
    }

    @Override
    public void setBlock(Coord coord, BlockType type) {
        int count = 0;
        switch (this.rotation) {
            case DEGREES_0: {
                count = 0;
                break;
            }
            case DEGREES_90: {
                count = 1;
                break;
            }
            case DEGREES_180: {
                count = 2;
                break;
            }
            case DEGREES_270: {
                count = 3;
            }
        }
        block16: for (int i = 0; i < count; ++i) {
            switch (type) {
                case BED_POSITIVE_X: {
                    type = BlockType.BED_POSITIVE_Z;
                    continue block16;
                }
                case BED_POSITIVE_Z: {
                    type = BlockType.BED_NEGATIVE_X;
                    continue block16;
                }
                case BED_NEGATIVE_X: {
                    type = BlockType.BED_NEGATIVE_Z;
                    continue block16;
                }
                case BED_NEGATIVE_Z: {
                    type = BlockType.BED_POSITIVE_X;
                    continue block16;
                }
                case FURNACE_POSITIVE_X: {
                    type = BlockType.FURNACE_POSITIVE_Z;
                    continue block16;
                }
                case FURNACE_POSITIVE_Z: {
                    type = BlockType.FURNACE_NEGATIVE_X;
                    continue block16;
                }
                case FURNACE_NEGATIVE_X: {
                    type = BlockType.FURNACE_NEGATIVE_Z;
                    continue block16;
                }
                case FURNACE_NEGATIVE_Z: {
                    type = BlockType.FURNACE_POSITIVE_X;
                    continue block16;
                }
            }
        }
        this.editor.setBlock(this.convert(coord), type);
    }

    @Override
    public void setChest(Coord coord, ChestType type) {
        this.editor.setChest(this.convert(coord), type);
    }

    @Override
    public void setSpawner(Coord coord, MonsterType type) {
        this.editor.setSpawner(this.convert(coord), type);
    }
}

