/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.ChestType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.MonsterType;
import net.puffish.castle.builder.WorldEditor;

public class TranslatedWorldEditor
extends WorldEditor {
    private WorldEditor editor;
    private Coord coord;

    public TranslatedWorldEditor(WorldEditor editor, Coord coord) {
        this.editor = editor;
        this.coord = coord;
    }

    private Coord convert(Coord coord) {
        return new Coord(this.coord.getX() + coord.getX(), this.coord.getY() + coord.getY(), this.coord.getZ() + coord.getZ());
    }

    @Override
    public boolean chooseTheme(Coord coord) {
        return this.editor.chooseTheme(coord);
    }

    @Override
    public void setBlockIfEmpty(Coord coord, BlockType type) {
        this.editor.setBlockIfEmpty(this.convert(coord), type);
    }

    @Override
    public void setBlock(Coord coord, BlockType type) {
        this.editor.setBlock(this.convert(coord), type);
    }

    @Override
    public void setChest(Coord coord, ChestType type) {
        this.editor.setChest(this.convert(coord), type);
    }

    @Override
    public void setSpawner(Coord coord, MonsterType type) {
        this.editor.setSpawner(this.convert(coord), type);
    }
}

