/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleNode;
import net.puffish.castle.generator.CastleNodeState;

public class Node {
    protected WorldEditor editor;
    protected Castle castle;
    protected CastleNode node;

    public Node(WorldEditor editor, Castle castle, CastleNode node) {
        this.editor = editor;
        this.castle = castle;
        this.node = node;
    }

    public void build() {
        this.buildWalls();
        if (this.node.getState() != CastleNodeState.ROOM) {
            this.buildConnections();
        }
        this.buildDoors();
        this.buildWindows();
        if (this.node.getState() != CastleNodeState.ROOM) {
            this.buildCorners();
        }
    }

    private void buildCorners() {
        int y;
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(3, y, 3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(3, 4, 3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(-3, y, 3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(-3, 4, 3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(3, y, -3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(3, 4, -3), BlockType.WALL_FRAME);
        for (y = 0; y < 4; ++y) {
            this.editor.setBlock(new Coord(-3, y, -3), BlockType.WALL);
        }
        this.editor.setBlock(new Coord(-3, 4, -3), BlockType.WALL_FRAME);
    }

    private void buildWalls() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        if (!this.node.getConnections().isPositiveX()) {
            x2 = 3;
            for (z2 = -3; z2 <= 3; ++z2) {
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
        }
        if (!this.node.getConnections().isPositiveY()) {
            z = 3;
            for (x = -3; x <= 3; ++x) {
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
        }
        if (!this.node.getConnections().isNegativeX()) {
            x2 = -3;
            for (z2 = -3; z2 <= 3; ++z2) {
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
        }
        if (!this.node.getConnections().isNegativeY()) {
            z = -3;
            for (x = -3; x <= 3; ++x) {
                for (y = 0; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
        }
    }

    private void buildConnections() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        if (this.node.getConnections().isPositiveX()) {
            x2 = 3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            for (y = 0; y < 4; ++y) {
                this.editor.setBlock(new Coord(x2, y, 2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, y, -2), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isPositiveY()) {
            z = 3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            for (y = 0; y < 4; ++y) {
                this.editor.setBlock(new Coord(2, y, z), BlockType.WALL);
                this.editor.setBlock(new Coord(-2, y, z), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isNegativeX()) {
            x2 = -3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            for (y = 0; y < 4; ++y) {
                this.editor.setBlock(new Coord(x2, y, 2), BlockType.WALL);
                this.editor.setBlock(new Coord(x2, y, -2), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isNegativeY()) {
            z = -3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            for (y = 0; y < 4; ++y) {
                this.editor.setBlock(new Coord(2, y, z), BlockType.WALL);
                this.editor.setBlock(new Coord(-2, y, z), BlockType.WALL);
            }
        }
    }

    private void buildDoors() {
        int x;
        int z;
        int y;
        int z2;
        int x2;
        if (this.node.getDoors().isPositiveX()) {
            x2 = 3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(3, 1, 0), BlockType.DOOR_X);
        }
        if (this.node.getDoors().isPositiveY()) {
            z = 3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(0, 1, 3), BlockType.DOOR_Y);
        }
        if (this.node.getDoors().isNegativeX()) {
            x2 = -3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x2, y, z2), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x2, 4, z2), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(-3, 1, 0), BlockType.DOOR_X);
        }
        if (this.node.getDoors().isNegativeY()) {
            z = -3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
                for (y = 1; y < 4; ++y) {
                    this.editor.setBlock(new Coord(x, y, z), BlockType.WALL);
                }
                this.editor.setBlock(new Coord(x, 4, z), BlockType.WALL_FRAME);
            }
            this.editor.setBlock(new Coord(0, 1, -3), BlockType.DOOR_Y);
        }
    }

    private void buildWindows() {
        if (this.node.getWindows().isPositiveX()) {
            this.editor.setBlock(new Coord(3, 2, 0), BlockType.WINDOW);
        }
        if (this.node.getWindows().isPositiveY()) {
            this.editor.setBlock(new Coord(0, 2, 3), BlockType.WINDOW);
        }
        if (this.node.getWindows().isNegativeX()) {
            this.editor.setBlock(new Coord(-3, 2, 0), BlockType.WINDOW);
        }
        if (this.node.getWindows().isNegativeY()) {
            this.editor.setBlock(new Coord(0, 2, -3), BlockType.WINDOW);
        }
    }
}

