/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.nodes.Node;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleNode;

public class RoofNode
extends Node {
    public RoofNode(WorldEditor editor, Castle castle, CastleNode node) {
        super(editor, castle, node);
    }

    @Override
    public void build() {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (x < -2 || z < -2 || x > 2 || z > 2) {
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
                    continue;
                }
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_0);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.buildRing(4 - i, i);
        }
        this.editor.setBlock(new Coord(0, 4, 0), BlockType.ROOF_TOP);
    }

    private void buildRing(int radius, int y) {
        for (int i = 1 - radius; i <= radius - 1; ++i) {
            this.editor.setBlock(new Coord(i, y, radius), BlockType.ROOF_POSITIVE_Z);
            this.editor.setBlock(new Coord(i, y, -radius), BlockType.ROOF_NEGATIVE_Z);
            this.editor.setBlock(new Coord(radius, y, i), BlockType.ROOF_POSITIVE_X);
            this.editor.setBlock(new Coord(-radius, y, i), BlockType.ROOF_NEGATIVE_X);
        }
        this.editor.setBlock(new Coord(radius, y, radius), BlockType.ROOF_POSITIVE_X_POSITIVE_Z);
        this.editor.setBlock(new Coord(-radius, y, radius), BlockType.ROOF_NEGATIVE_X_POSITIVE_Z);
        this.editor.setBlock(new Coord(radius, y, -radius), BlockType.ROOF_POSITIVE_X_NEGATIVE_Z);
        this.editor.setBlock(new Coord(-radius, y, -radius), BlockType.ROOF_NEGATIVE_X_NEGATIVE_Z);
    }
}

