/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.builder.nodes;

import net.puffish.castle.builder.BlockType;
import net.puffish.castle.builder.Coord;
import net.puffish.castle.builder.WorldEditor;
import net.puffish.castle.builder.nodes.Node;
import net.puffish.castle.generator.Castle;
import net.puffish.castle.generator.CastleNode;

public class WalkNode
extends Node {
    public WalkNode(WorldEditor editor, Castle castle, CastleNode node) {
        super(editor, castle, node);
    }

    @Override
    public void build() {
        this.buildWalk();
        this.buildWalkDoors();
    }

    private void buildWalk() {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (x < -2 || z < -2 || x > 2 || z > 2) {
                    this.editor.setBlock(new Coord(x, 0, z), BlockType.WALL);
                    continue;
                }
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_1);
            }
        }
        this.editor.setBlock(new Coord(3, 1, 3), BlockType.WALL);
        this.editor.setBlock(new Coord(3, 2, 3), BlockType.WALL);
        this.editor.setBlock(new Coord(-3, 1, 3), BlockType.WALL);
        this.editor.setBlock(new Coord(-3, 2, 3), BlockType.WALL);
        this.editor.setBlock(new Coord(3, 1, -3), BlockType.WALL);
        this.editor.setBlock(new Coord(3, 2, -3), BlockType.WALL);
        this.editor.setBlock(new Coord(-3, 1, -3), BlockType.WALL);
        this.editor.setBlock(new Coord(-3, 2, -3), BlockType.WALL);
    }

    private void buildWalkDoors() {
        int x;
        int z;
        int z2;
        int x2;
        if (this.node.getConnections().isPositiveX()) {
            x2 = 3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_1);
            }
        } else {
            x2 = 3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL);
                if ((z2 + 4) % 2 != 1) continue;
                this.editor.setBlock(new Coord(x2, 2, z2), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isPositiveY()) {
            z = 3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_1);
            }
        } else {
            z = 3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL);
                if ((x + 4) % 2 != 1) continue;
                this.editor.setBlock(new Coord(x, 2, z), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isNegativeX()) {
            x2 = -3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 0, z2), BlockType.FLOOR_1);
            }
        } else {
            x2 = -3;
            for (z2 = -2; z2 <= 2; ++z2) {
                this.editor.setBlock(new Coord(x2, 1, z2), BlockType.WALL);
                if ((z2 + 4) % 2 != 1) continue;
                this.editor.setBlock(new Coord(x2, 2, z2), BlockType.WALL);
            }
        }
        if (this.node.getConnections().isNegativeY()) {
            z = -3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 0, z), BlockType.FLOOR_1);
            }
        } else {
            z = -3;
            for (x = -2; x <= 2; ++x) {
                this.editor.setBlock(new Coord(x, 1, z), BlockType.WALL);
                if ((x + 4) % 2 != 1) continue;
                this.editor.setBlock(new Coord(x, 2, z), BlockType.WALL);
            }
        }
    }
}

