/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.util.List;
import net.puffish.castle.config.Config;

public class ConfigParser {
    public static Config parseConfig(List<String> lines) {
        Config config = new Config();
        for (String line : lines) {
            int i;
            if (line.startsWith("#") || line.isEmpty() || (i = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, i).toLowerCase().trim();
            String value = line.substring(i + 1, line.length()).trim();
            try {
                if (key.equals("max-y")) {
                    config.setMaxY(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("min-y")) {
                    config.setMinY(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("max-foundation-thickness")) {
                    config.setMaxFoundationThickness(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("section-size")) {
                    config.setSectionSize(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("max-castle-size")) {
                    config.setMaxCastleSize(Integer.parseInt(value));
                    continue;
                }
                if (!key.equals("min-castle-size")) continue;
                config.setMinCastleSize(Integer.parseInt(value));
            }
            catch (Exception e) {
                System.out.println("Could not parse line! \"" + line + "\"");
                e.printStackTrace();
            }
        }
        if (config.isValid()) {
            return config;
        }
        return null;
    }
}

