/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.puffish.castle.config.Config;
import net.puffish.castle.config.ConfigParser;
import net.puffish.castle.config.chest.Chest;
import net.puffish.castle.config.chest.ChestParser;
import net.puffish.castle.config.parser.BlockParser;
import net.puffish.castle.config.parser.ItemParser;
import net.puffish.castle.config.theme.Theme;
import net.puffish.castle.config.theme.ThemeParser;

public class Configuration {
    public static void copyDefaultConfig(File rootDirectory, String[] files) {
        for (String name : files) {
            try {
                int length;
                InputStream input = Configuration.class.getResourceAsStream("/resources/" + name);
                File file = new File(rootDirectory, name);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FileOutputStream output = new FileOutputStream(file);
                byte[] buffer = new byte[4096];
                while ((length = input.read(buffer)) != -1) {
                    ((OutputStream)output).write(buffer, 0, length);
                }
                ((OutputStream)output).close();
                input.close();
            }
            catch (Exception e) {
                System.out.println("Cound not copy file!");
                e.printStackTrace();
            }
        }
    }

    public static Config loadConfig(File rootDirectory) {
        File file = new File(rootDirectory, "config.cfg");
        List<String> lines = Configuration.readLines(file);
        Config config = ConfigParser.parseConfig(lines);
        return config;
    }

    public static <T> Chest<T> loadChest(File rootDirectory, ItemParser<T> itemParser) {
        File file = new File(rootDirectory, "chests.cfg");
        List<String> lines = Configuration.readLines(file);
        Chest<T> chest = ChestParser.parseChest(itemParser, lines);
        return chest;
    }

    public static <T> List<Theme<T>> loadThemes(File rootDirectory, BlockParser<T> blockParser) {
        ArrayList<Theme<T>> themes = new ArrayList<Theme<T>>();
        File themesDirectory = new File(rootDirectory, "themes/");
        if (!themesDirectory.exists()) {
            themesDirectory.mkdirs();
        }
        for (File file : themesDirectory.listFiles()) {
            List<String> lines = Configuration.readLines(file);
            Theme<T> theme = ThemeParser.parseTheme(blockParser, lines);
            if (theme == null) continue;
            themes.add(theme);
        }
        return themes;
    }

    private static List<String> readLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                lines.add(line.trim());
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }
}

