/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config.chest;

import java.util.ArrayList;
import java.util.List;
import net.puffish.castle.config.chest.Chest;
import net.puffish.castle.config.chest.ChestItem;
import net.puffish.castle.config.parser.ItemParser;

public class ChestParser {
    public static <T> Chest<T> parseChest(ItemParser<T> itemParser, List<String> lines) {
        Chest chest = new Chest();
        ArrayList junkItems = new ArrayList();
        ArrayList healItems = new ArrayList();
        ArrayList lootItems = new ArrayList();
        for (String line : lines) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            try {
                ChestItem<T> item;
                String[] pieces = line.split("\\s+");
                String type = pieces[0].toLowerCase();
                if (pieces.length == 2) {
                    int percent = Integer.parseInt(pieces[1].replace("%", ""));
                    if (type.equals("junk")) {
                        chest.setJunkPercent(percent);
                        continue;
                    }
                    if (type.equals("heal")) {
                        chest.setHealPercent(percent);
                        continue;
                    }
                    if (!type.equals("loot")) continue;
                    chest.setLootPercent(percent);
                    continue;
                }
                int weight = Integer.parseInt(pieces[1]);
                String name = pieces[2];
                int min = 1;
                int max = 1;
                if (pieces.length == 5) {
                    min = Integer.parseInt(pieces[3]);
                    max = Integer.parseInt(pieces[4]);
                }
                if ((item = ChestParser.createChestItem(itemParser, name, weight, min, max)) == null) continue;
                if (type.equals("junk")) {
                    junkItems.add(item);
                    continue;
                }
                if (type.equals("heal")) {
                    healItems.add(item);
                    continue;
                }
                if (!type.equals("loot")) continue;
                lootItems.add(item);
            }
            catch (Exception e) {
                System.out.println("Could not parse line! \"" + line + "\"");
                e.printStackTrace();
            }
        }
        if (!junkItems.isEmpty()) {
            chest.setJunkItems(junkItems);
        }
        if (!healItems.isEmpty()) {
            chest.setHealItems(healItems);
        }
        if (!lootItems.isEmpty()) {
            chest.setLootItems(lootItems);
        }
        if (chest.isValid()) {
            return chest;
        }
        return null;
    }

    private static <T> ChestItem<T> createChestItem(ItemParser<T> itemParser, String name, int weight, int min, int max) {
        if (min > max) {
            return null;
        }
        T obj = itemParser.parseItem(name);
        if (obj != null) {
            return new ChestItem<T>(obj, weight, min, max);
        }
        System.out.println("Could not parse item name! \"" + name + "\"");
        return null;
    }
}

