/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.config.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.puffish.castle.config.parser.BlockParser;
import net.puffish.castle.config.theme.Theme;

public class ThemeParser {
    public static <T> Theme<T> parseTheme(BlockParser<T> blockParser, List<String> lines) {
        Theme<T> theme = new Theme<T>();
        for (String line : lines) {
            int i;
            if (line.startsWith("#") || line.isEmpty() || (i = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, i).toLowerCase().trim();
            String value = line.substring(i + 1, line.length()).trim();
            if (key.equals("wall")) {
                theme.setWallBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("wall_frame")) {
                theme.setWallFrameBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("floor0")) {
                theme.setFloor0Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("floor1")) {
                theme.setFloor1Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("ceil")) {
                theme.setCeilBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("pillar0")) {
                theme.setPillar0Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("pillar1")) {
                theme.setPillar1Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("fence0")) {
                theme.setFence0Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("fence1")) {
                theme.setFence1Blocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("window")) {
                theme.setWindowBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("spiral_stair_slab")) {
                theme.setSpiralStairsBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("roof_stair")) {
                theme.setRoofStairsBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("roof_slab")) {
                theme.setRoofSlabBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("door")) {
                theme.setDoorBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("foundation")) {
                theme.setFoundationBlocks(ThemeParser.splitAndParseBlock(blockParser, value));
                continue;
            }
            if (key.equals("biome-whitelist")) {
                theme.setBiomeWhitelist(ThemeParser.splitAndParseString(value));
                continue;
            }
            if (key.equals("biome-blacklist")) {
                theme.setBiomeBlacklist(ThemeParser.splitAndParseString(value));
                continue;
            }
            if (key.equals("spawner-easy")) {
                theme.setMobsEasy(ThemeParser.splitAndParseString(value));
                continue;
            }
            if (key.equals("spawner-medium")) {
                theme.setMobsMedium(ThemeParser.splitAndParseString(value));
                continue;
            }
            if (!key.equals("spawner-hard")) continue;
            theme.setMobsHard(ThemeParser.splitAndParseString(value));
        }
        if (theme.isValid()) {
            return theme;
        }
        return null;
    }

    private static List<String> splitAndParseString(String str) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : Arrays.asList(str.split("\\s+"))) {
            if (name.isEmpty()) continue;
            list.add(name);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static <T> List<T> splitAndParseBlock(BlockParser<T> blockParser, String str) {
        ArrayList<T> list = new ArrayList<T>();
        for (String name : Arrays.asList(str.split("\\s+"))) {
            if (name.isEmpty()) continue;
            T obj = blockParser.parseBlock(name);
            if (obj == null) {
                System.out.println("Could not parse block name! \"" + name + "\"");
                continue;
            }
            list.add(obj);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }
}

