/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.puffish.castle.generator.CastleArea;
import net.puffish.castle.generator.CastleLayer;
import net.puffish.castle.generator.CastleNode;
import net.puffish.castle.generator.CastleNodeState;
import net.puffish.castle.generator.CastleRoom;
import net.puffish.castle.generator.Direction;
import net.puffish.castle.generator.Rotation;

public class Castle {
    private List<CastleLayer> layers;
    private List<CastleRoom> rooms;
    private List<CastleArea> areas;
    private int width;
    private int height;
    private boolean valid;

    public Castle(int width, int height) {
        this.width = width;
        this.height = height;
        this.layers = new ArrayList<CastleLayer>();
        this.rooms = new ArrayList<CastleRoom>();
        this.areas = new ArrayList<CastleArea>();
    }

    public void generate(Random random) {
        int i;
        int y;
        int x;
        Rotation rotation;
        Object layer;
        CastleLayer belowLayer = null;
        do {
            if (this.layers.isEmpty()) {
                layer = new CastleLayer(this.width, this.height);
                ((CastleLayer)layer).placeEntrance(random);
            } else {
                layer = belowLayer.nextLayer();
                if (this.layers.size() >= 3) {
                    int count = (int)Math.floor(Math.sqrt(((CastleLayer)layer).getRealWidth() * ((CastleLayer)layer).getRealHeight()) / 2.0);
                    if (count < 1) {
                        count = 1;
                    }
                    for (int i2 = 0; i2 < count; ++i2) {
                        ((CastleLayer)layer).cut(random);
                    }
                }
            }
            if (belowLayer != null && !this.tryCreateStairsBetweenLayersWithTower((CastleLayer)layer)) {
                this.createAlternativeStairsBetweenLayers(belowLayer, (CastleLayer)layer, random);
            }
            ((CastleLayer)layer).placeRoofs();
            this.layers.add((CastleLayer)layer);
            belowLayer = layer;
        } while (!((CastleLayer)layer).isSmall());
        this.valid = true;
        for (CastleRoom room : this.rooms) {
            int placed = 0;
            for (int i3 = 0; i3 < 128; ++i3) {
                rotation = null;
                switch (random.nextInt(4)) {
                    case 0: {
                        rotation = Rotation.DEGREES_0;
                        break;
                    }
                    case 1: {
                        rotation = Rotation.DEGREES_90;
                        break;
                    }
                    case 2: {
                        rotation = Rotation.DEGREES_180;
                        break;
                    }
                    case 3: {
                        rotation = Rotation.DEGREES_270;
                    }
                }
                x = random.nextInt(this.width - room.getRotatedWidth(rotation) + 1);
                y = random.nextInt(this.height - room.getRotatedHeight(rotation) + 1);
                int z = random.nextInt(this.layers.size() - room.getLevels() + 1);
                if (!this.tryPlaceRoom(x, y, z, rotation, room)) continue;
                this.areas.add(new CastleArea(x, y, z, rotation, room));
                if (++placed == room.getMaxCount()) break;
            }
            if (placed >= room.getMinCount()) continue;
            this.valid = false;
            return;
        }
        for (int i4 = 0; i4 < this.layers.size(); ++i4) {
            CastleLayer layer2 = this.layers.get(i4);
            layer2.generate(random);
        }
        CastleLayer roofsLayer = this.layers.get(this.layers.size() - 1).nextLayer();
        roofsLayer.placeRoofs();
        this.layers.add(roofsLayer);
        for (i = 0; i < this.layers.size(); ++i) {
            CastleLayer layer3 = this.layers.get(i);
            layer3.fixRelations();
        }
        for (i = 0; i < this.areas.size(); ++i) {
            CastleArea area = this.areas.get(i);
            CastleRoom room = area.getRoom();
            rotation = area.getRotation();
            x = area.getX();
            y = area.getY();
            int level = area.getLevel();
            int w = room.getRotatedWidth(rotation);
            int h = room.getRotatedHeight(rotation);
            for (int k = level; k < room.getLevels() + level; ++k) {
                int j;
                CastleLayer layer4 = this.layers.get(k);
                for (j = 0; j < w; ++j) {
                    if (y + h < layer4.getHeight()) {
                        layer4.createDoors(layer4.getGrid()[x + j][y + h - 1], layer4.getGrid()[x + j][y + h]);
                    }
                    if (y - 1 < 0) continue;
                    layer4.createDoors(layer4.getGrid()[x + j][y], layer4.getGrid()[x + j][y - 1]);
                }
                for (j = 0; j < h; ++j) {
                    if (x + w < layer4.getWidth()) {
                        layer4.createDoors(layer4.getGrid()[x + w - 1][y + j], layer4.getGrid()[x + w][y + j]);
                    }
                    if (x - 1 < 0) continue;
                    layer4.createDoors(layer4.getGrid()[x][y + j], layer4.getGrid()[x - 1][y + j]);
                }
            }
        }
    }

    private boolean tryPlaceRoom(int x, int y, int level, Rotation rotation, CastleRoom room) {
        int k;
        int j;
        int i;
        CastleLayer layer;
        int k2;
        for (k2 = level; k2 < room.getLevels() + level; ++k2) {
            layer = this.layers.get(k2);
            if (layer.isSmall()) {
                return false;
            }
            for (i = x; i < room.getRotatedWidth(rotation) + x; ++i) {
                for (j = y; j < room.getRotatedHeight(rotation) + y; ++j) {
                    CastleNode node = layer.getGrid()[i][j];
                    if (node.getState() != CastleNodeState.HALLWAY) {
                        return false;
                    }
                    if (node.isEntrance()) {
                        return false;
                    }
                    if (!node.isStairs() && !node.isStairsBelow()) continue;
                    return false;
                }
            }
        }
        for (k2 = 0; k2 < room.getLevels(); ++k2) {
            layer = this.layers.get(level + k2);
            for (i = 0; i < room.getRotatedWidth(rotation); ++i) {
                for (j = 0; j < room.getRotatedHeight(rotation); ++j) {
                    CastleNode to;
                    CastleNode from = layer.getGrid()[x + i][y + j];
                    Direction direction = room.getRotatedConnection(rotation, i, j, k2);
                    if (x + i + 1 < layer.getWidth()) {
                        to = layer.getGrid()[x + i + 1][y + j];
                        if (direction.isPositiveX() ? !this.canSetConnection(layer, from, to) : this.isAnyConnection(layer, from, to)) {
                            return false;
                        }
                    }
                    if (y + j + 1 < layer.getHeight()) {
                        to = layer.getGrid()[x + i][y + j + 1];
                        if (direction.isPositiveY() ? !this.canSetConnection(layer, from, to) : this.isAnyConnection(layer, from, to)) {
                            return false;
                        }
                    }
                    if (x + i - 1 >= 0) {
                        to = layer.getGrid()[x + i - 1][y + j];
                        if (direction.isNegativeX() ? !this.canSetConnection(layer, from, to) : this.isAnyConnection(layer, from, to)) {
                            return false;
                        }
                    }
                    if (y + j - 1 < 0) continue;
                    to = layer.getGrid()[x + i][y + j - 1];
                    if (!(direction.isNegativeY() ? !this.canSetConnection(layer, from, to) : this.isAnyConnection(layer, from, to))) continue;
                    return false;
                }
            }
        }
        for (k2 = level; k2 < room.getLevels() + level; ++k2) {
            layer = this.layers.get(k2);
            layer.resetTemporaryChanges();
        }
        this.placeRoom(x, y, level, rotation, room);
        boolean valid = true;
        for (k = level; k < room.getLevels() + level; ++k) {
            CastleLayer layer2 = this.layers.get(k);
            if (layer2.validateTemporaryChanges()) continue;
            valid = false;
            break;
        }
        if (valid) {
            for (k = level; k < room.getLevels() + level; ++k) {
                CastleLayer layer3 = this.layers.get(k);
                layer3.applyTemporaryChanges();
            }
        }
        return valid;
    }

    private boolean canSetConnection(CastleLayer layer, CastleNode from, CastleNode to) {
        if (to.getState() == CastleNodeState.HALLWAY) {
            return true;
        }
        return this.isAnyConnection(layer, from, to);
    }

    private boolean isAnyConnection(CastleLayer layer, CastleNode node0, CastleNode node1) {
        return layer.hasConnection(node0, node1) || layer.hasOptionalConnection(node0, node1);
    }

    private void placeRoom(int x, int y, int level, Rotation rotation, CastleRoom room) {
        for (int k = 0; k < room.getLevels(); ++k) {
            CastleLayer layer = this.layers.get(level + k);
            for (int i = 0; i < room.getRotatedWidth(rotation); ++i) {
                for (int j = 0; j < room.getRotatedHeight(rotation); ++j) {
                    Direction direction;
                    CastleNode node = layer.getGrid()[x + i][y + j];
                    if (i > 0) {
                        layer.setTemporaryConnection(layer.getGrid()[x + i - 1][y + j], node, true);
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i - 1][y + j], node, true);
                    }
                    if (j > 0) {
                        layer.setTemporaryConnection(layer.getGrid()[x + i][y + j - 1], node, true);
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i][y + j - 1], node, true);
                    }
                    if ((direction = room.getRotatedConnection(rotation, i, j, k)).isPositiveX() && x + i + 1 < layer.getWidth()) {
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i + 1][y + j], node, true);
                    }
                    if (direction.isPositiveY() && y + j + 1 < layer.getHeight()) {
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i][y + j + 1], node, true);
                    }
                    if (direction.isNegativeX() && x + i - 1 >= 0) {
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i - 1][y + j], node, true);
                    }
                    if (direction.isNegativeY() && y + j - 1 >= 0) {
                        layer.setTemporaryOptionalConnection(layer.getGrid()[x + i][y + j - 1], node, true);
                    }
                    node.setTemporaryState(CastleNodeState.ROOM);
                }
            }
        }
    }

    private boolean tryCreateStairsBetweenLayersWithTower(CastleLayer layer) {
        for (int x = 0; x < layer.getWidth(); ++x) {
            for (int y = 0; y < layer.getHeight(); ++y) {
                CastleNode tower;
                CastleNode node = layer.getGrid()[x][y];
                if ((!layer.isSmall() ? node.getState() != CastleNodeState.HALLWAY : node.getState() != CastleNodeState.WALK) || (tower = layer.getTowerWithStairsBelowAdjacentToNode(node)) == null) continue;
                layer.setConnection(tower, node, true);
                return true;
            }
        }
        return false;
    }

    private void createAlternativeStairsBetweenLayers(CastleLayer belowLayer, CastleLayer layer, Random random) {
        int x = layer.getCutX() + random.nextInt(this.width - layer.getCutW() - layer.getCutX());
        int y = layer.getCutY() + random.nextInt(this.height - layer.getCutH() - layer.getCutY());
        layer.getGrid()[x][y].setStairsBelow(true);
        belowLayer.getGrid()[x][y].setStairs(true);
    }

    public void addRoom(CastleRoom room) {
        this.rooms.add(room);
    }

    public List<CastleLayer> getLayers() {
        return this.layers;
    }

    public List<CastleArea> getAreas() {
        return this.areas;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isValid() {
        return this.valid;
    }
}

