/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.castle.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import net.puffish.castle.generator.CastleNode;
import net.puffish.castle.generator.CastleNodeState;
import net.puffish.castle.generator.Direction;
import net.puffish.castle.generator.Position;

public class CastleLayer {
    private static final Position[] neighbors4 = new Position[]{new Position(1, 0), new Position(0, 1), new Position(-1, 0), new Position(0, -1)};
    private static final Position[] neighbors8 = new Position[]{new Position(1, 0), new Position(0, 1), new Position(-1, 0), new Position(0, -1), new Position(1, 1), new Position(-1, -1), new Position(-1, 1), new Position(1, -1)};
    private CastleNode[][] grid;
    private int cutX;
    private int cutY;
    private int cutW;
    private int cutH;
    private int width;
    private int height;
    private int level;

    public CastleLayer(int width, int height) {
        this(0, 0, 0, 0, width, height, 0);
    }

    public CastleLayer(int cutX, int cutY, int cutW, int cutH, int width, int height, int level) {
        int y;
        int x;
        this.cutX = cutX;
        this.cutY = cutY;
        this.cutW = cutW;
        this.cutH = cutH;
        this.width = width;
        this.height = height;
        this.level = level;
        this.grid = new CastleNode[width][height];
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                this.grid[x][y] = new CastleNode(x, y, level);
            }
        }
        if (!this.isSmall()) {
            for (x = cutX; x < width - cutW; ++x) {
                for (y = cutY; y < height - cutH; ++y) {
                    CastleNode node = this.grid[x][y];
                    node.setState(CastleNodeState.HALLWAY);
                }
            }
        }
    }

    public void generate(Random random) {
        if (this.isSmall()) {
            for (int x = this.cutX; x < this.width - this.cutW; ++x) {
                for (int y = this.cutY; y < this.height - this.cutH; ++y) {
                    CastleNode node = this.grid[x][y];
                    node.setState(CastleNodeState.WALK);
                }
            }
            return;
        }
        this.setAllNodesUnvisited();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                CastleNode current = this.grid[x][y];
                for (int i = 0; i < 4; ++i) {
                    Position pos = neighbors4[i];
                    if (this.isOutsideCuttedBounds(current, pos)) continue;
                    CastleNode neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()];
                    if (current.getState() != CastleNodeState.HALLWAY || neighbor.getState() != CastleNodeState.HALLWAY) continue;
                    this.setOptionalConnection(current, neighbor, true);
                }
            }
        }
        CastleNode current = null;
        for (int x = this.cutX; x < this.width - this.cutW; ++x) {
            for (int y = this.cutY; y < this.height - this.cutH; ++y) {
                CastleNode node = this.grid[x][y];
                if (node.getState() != CastleNodeState.HALLWAY) continue;
                current = node;
            }
        }
        if (current == null) {
            return;
        }
        Stack<CastleNode> stack = new Stack<CastleNode>();
        current.setVisited(true);
        stack.push(current);
        while (!stack.isEmpty()) {
            current = (CastleNode)stack.pop();
            List<CastleNode> neighbors = this.getUnvisitedNeighbors(current);
            if (neighbors.isEmpty()) continue;
            stack.push(current);
            CastleNode neighbor = neighbors.get(random.nextInt(neighbors.size()));
            this.setConnection(current, neighbor, true);
            neighbor.setVisited(true);
            stack.push(neighbor);
        }
    }

    public boolean validateTemporaryChanges() {
        CastleNode current;
        if (this.isSmall()) {
            return true;
        }
        this.setAllNodesUnvisited();
        int total = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                current = this.grid[x][y];
                if (current.getTemporaryState() != CastleNodeState.HALLWAY && current.getTemporaryState() != CastleNodeState.ROOM) continue;
                ++total;
            }
        }
        int visited = 0;
        Stack<CastleNode> stack = new Stack<CastleNode>();
        current = null;
        for (int x = this.cutX; x < this.width - this.cutW; ++x) {
            for (int y = this.cutY; y < this.height - this.cutH; ++y) {
                CastleNode node = this.grid[x][y];
                if (node.getTemporaryState() != CastleNodeState.HALLWAY) continue;
                current = node;
            }
        }
        if (current == null) {
            return false;
        }
        current.setVisited(true);
        ++visited;
        stack.push(current);
        while (!stack.isEmpty()) {
            current = (CastleNode)stack.pop();
            for (int i = 0; i < 4; ++i) {
                CastleNode neighbor;
                Position pos = neighbors4[i];
                if (this.isOutsideCuttedBounds(current, pos) || (neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()]).isVisited() || current.getTemporaryState() != CastleNodeState.HALLWAY && current.getTemporaryState() != CastleNodeState.ROOM || (current.getTemporaryState() != CastleNodeState.HALLWAY || neighbor.getTemporaryState() != CastleNodeState.HALLWAY) && !this.hasTemporaryOptionalConnection(current, neighbor) && !this.hasTemporaryConnection(current, neighbor)) continue;
                neighbor.setVisited(true);
                ++visited;
                stack.push(neighbor);
            }
        }
        return visited == total;
    }

    public void placeRoofs() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                CastleNode current = this.grid[x][y];
                if (current.getState() != CastleNodeState.TOWER) continue;
                this.tryPlaceRoof(current);
            }
        }
    }

    public void fixRelations() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                CastleNode current = this.grid[x][y];
                for (int i = 0; i < 4; ++i) {
                    Position pos = neighbors4[i];
                    if (this.isOutsideBounds(current, pos)) {
                        if (current.isEntrance()) {
                            this.createEntrance(current, pos);
                        }
                        if (current.getState() != CastleNodeState.HALLWAY && current.getState() != CastleNodeState.TOWER && current.getState() != CastleNodeState.ROOM) continue;
                        this.createWindow(current, pos);
                        continue;
                    }
                    CastleNode neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()];
                    if (current.getState() == CastleNodeState.TOWER && neighbor.getState() == CastleNodeState.WALK) {
                        this.setConnection(current, neighbor, true);
                    }
                    if (current.getState() == CastleNodeState.WALK && neighbor.getState() == CastleNodeState.WALK) {
                        this.setConnection(current, neighbor, true);
                    }
                    if (current.getState() == CastleNodeState.TOWER && neighbor.getState() == CastleNodeState.HALLWAY) {
                        this.setConnection(current, neighbor, true);
                    }
                    if (current.getState() != CastleNodeState.HALLWAY && current.getState() != CastleNodeState.TOWER && current.getState() != CastleNodeState.ROOM || neighbor.getState() != CastleNodeState.EMPTY && neighbor.getState() != CastleNodeState.WALK) continue;
                    this.createWindow(current, pos);
                }
            }
        }
    }

    private void createEntrance(CastleNode current, Position pos) {
        if (pos.getX() == 1) {
            current.getConnections().setPositiveX(true);
        } else if (pos.getY() == 1) {
            current.getConnections().setPositiveY(true);
        } else if (pos.getX() == -1) {
            current.getConnections().setNegativeX(true);
        } else if (pos.getY() == -1) {
            current.getConnections().setNegativeY(true);
        }
    }

    private void createWindow(CastleNode current, Position pos) {
        if (pos.getX() == 1) {
            if (!current.getConnections().isPositiveX()) {
                current.getWindows().setPositiveX(true);
            }
        } else if (pos.getY() == 1) {
            if (!current.getConnections().isPositiveY()) {
                current.getWindows().setPositiveY(true);
            }
        } else if (pos.getX() == -1) {
            if (!current.getConnections().isNegativeX()) {
                current.getWindows().setNegativeX(true);
            }
        } else if (pos.getY() == -1 && !current.getConnections().isNegativeY()) {
            current.getWindows().setNegativeY(true);
        }
    }

    public void createDoors(CastleNode node0, CastleNode node1) {
        if (this.hasConnection(node0, node1)) {
            this.setDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getDoors(), node1.getDoors(), true);
        }
    }

    public void setConnection(CastleNode node0, CastleNode node1, boolean value) {
        this.setDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getConnections(), node1.getConnections(), value);
    }

    public boolean hasConnection(CastleNode node0, CastleNode node1) {
        return this.hasDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getConnections(), node1.getConnections());
    }

    private void setOptionalConnection(CastleNode node0, CastleNode node1, boolean value) {
        this.setDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getOptionalConnections(), node1.getOptionalConnections(), value);
    }

    public boolean hasOptionalConnection(CastleNode node0, CastleNode node1) {
        return this.hasDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getOptionalConnections(), node1.getOptionalConnections());
    }

    public void setTemporaryConnection(CastleNode node0, CastleNode node1, boolean value) {
        this.setDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getTemporaryConnections(), node1.getTemporaryConnections(), value);
    }

    public boolean hasTemporaryConnection(CastleNode node0, CastleNode node1) {
        return this.hasDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getTemporaryConnections(), node1.getTemporaryConnections());
    }

    public void setTemporaryOptionalConnection(CastleNode node0, CastleNode node1, boolean value) {
        this.setDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getTemporaryOptionalConnections(), node1.getTemporaryOptionalConnections(), value);
    }

    public boolean hasTemporaryOptionalConnection(CastleNode node0, CastleNode node1) {
        return this.hasDirection(node0.getX() - node1.getX(), node0.getY() - node1.getY(), node0.getTemporaryOptionalConnections(), node1.getTemporaryOptionalConnections());
    }

    private boolean hasDirection(int differenceX, int differenceY, Direction direction0, Direction direction1) {
        if (differenceX == 1) {
            return direction0.isNegativeX() && direction1.isPositiveX();
        }
        if (differenceX == -1) {
            return direction0.isPositiveX() && direction1.isNegativeX();
        }
        if (differenceY == 1) {
            return direction0.isNegativeY() && direction1.isPositiveY();
        }
        if (differenceY == -1) {
            return direction0.isPositiveY() && direction1.isNegativeY();
        }
        return false;
    }

    private void setDirection(int differenceX, int differenceY, Direction direction0, Direction direction1, boolean value) {
        if (differenceX == 1) {
            direction0.setNegativeX(value);
            direction1.setPositiveX(value);
        } else if (differenceX == -1) {
            direction0.setPositiveX(value);
            direction1.setNegativeX(value);
        } else if (differenceY == 1) {
            direction0.setNegativeY(value);
            direction1.setPositiveY(value);
        } else if (differenceY == -1) {
            direction0.setPositiveY(value);
            direction1.setNegativeY(value);
        }
    }

    private List<CastleNode> getUnvisitedNeighbors(CastleNode current) {
        ArrayList<CastleNode> list = new ArrayList<CastleNode>();
        for (int i = 0; i < 4; ++i) {
            CastleNode neighbor;
            Position pos = neighbors4[i];
            if (this.isOutsideCuttedBounds(current, pos) || (neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()]).isVisited() || !this.hasOptionalConnection(current, neighbor)) continue;
            list.add(neighbor);
        }
        return list;
    }

    public void applyTemporaryChanges() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.grid[x][y].applyTemporaryChanges();
            }
        }
    }

    public void resetTemporaryChanges() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.grid[x][y].resetTemporaryChanges();
            }
        }
    }

    private void setAllNodesUnvisited() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.grid[x][y].setVisited(false);
            }
        }
    }

    public CastleNode getTowerWithStairsBelowAdjacentToNode(CastleNode node) {
        for (int i = 0; i < 4; ++i) {
            CastleNode neighbor;
            Position pos = neighbors4[i];
            if (this.isOutsideBounds(node, pos) || (neighbor = this.grid[node.getX() + pos.getX()][node.getY() + pos.getY()]).getState() != CastleNodeState.TOWER || !neighbor.isStairsBelow()) continue;
            return neighbor;
        }
        return null;
    }

    private void tryPlaceTower(CastleNode current) {
        for (int i = 0; i < 8; ++i) {
            CastleNode neighbor;
            Position pos = neighbors8[i];
            if (this.isOutsideBounds(current, pos) || (neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()]).getState() != CastleNodeState.TOWER) continue;
            return;
        }
        current.setState(CastleNodeState.TOWER);
        current.setStairs(true);
    }

    private void tryPlaceRoof(CastleNode current) {
        for (int i = 0; i < 8; ++i) {
            CastleNode neighbor;
            Position pos = neighbors8[i];
            if (this.isOutsideBounds(current, pos) || (neighbor = this.grid[current.getX() + pos.getX()][current.getY() + pos.getY()]).getState() == CastleNodeState.EMPTY) continue;
            return;
        }
        current.setStairs(false);
        current.setState(CastleNodeState.ROOF);
    }

    public void placeEntrance(Random random) {
        CastleNode node = this.getMiddleNodeOnRandomEdge(random);
        node.setEntrance(true);
    }

    public void cut(Random random) {
        int side = random.nextInt(4);
        int start = 0;
        int end = 0;
        switch (side) {
            case 0: 
            case 2: {
                start = this.cutY;
                end = this.height - this.cutH - 1;
                break;
            }
            case 1: 
            case 3: {
                start = this.cutX;
                end = this.width - this.cutW - 1;
            }
        }
        boolean reversed = random.nextBoolean();
        boolean noTower = true;
        for (int j = start; j <= end; ++j) {
            CastleNode node = null;
            int i = reversed ? start + end - j : j;
            switch (side) {
                case 0: {
                    node = this.grid[this.cutX][i];
                    break;
                }
                case 1: {
                    node = this.grid[i][this.cutY];
                    break;
                }
                case 2: {
                    node = this.grid[this.width - 1 - this.cutW][i];
                    break;
                }
                case 3: {
                    node = this.grid[i][this.height - 1 - this.cutH];
                }
            }
            node.setState(CastleNodeState.WALK);
            if ((i == start || i == end) && (double)random.nextFloat() < 0.7) {
                this.tryPlaceTower(node);
            }
            if (node.getState() == CastleNodeState.TOWER || this.getTowerWithStairsBelowAdjacentToNode(node) == null) continue;
            noTower = false;
        }
        if (noTower) {
            switch (side) {
                case 0: {
                    int y = this.cutY + random.nextInt(this.height - this.cutH - this.cutY);
                    this.setConnection(this.grid[this.cutX][y], this.grid[this.cutX + 1][y], true);
                    break;
                }
                case 1: {
                    int x = this.cutX + random.nextInt(this.width - this.cutW - this.cutX);
                    this.setConnection(this.grid[x][this.cutY], this.grid[x][this.cutY + 1], true);
                    break;
                }
                case 2: {
                    int y = this.cutY + random.nextInt(this.height - this.cutH - this.cutY);
                    this.setConnection(this.grid[this.width - 1 - this.cutW][y], this.grid[this.width - 1 - this.cutW - 1][y], true);
                    break;
                }
                case 3: {
                    int x = this.cutX + random.nextInt(this.width - this.cutW - this.cutX);
                    this.setConnection(this.grid[x][this.height - 1 - this.cutH - 1], this.grid[x][this.height - 1 - this.cutH], true);
                }
            }
        }
        switch (side) {
            case 0: {
                ++this.cutX;
                break;
            }
            case 1: {
                ++this.cutY;
                break;
            }
            case 2: {
                ++this.cutW;
                break;
            }
            case 3: {
                ++this.cutH;
            }
        }
    }

    private CastleNode getMiddleNodeOnRandomEdge(Random random) {
        int side = random.nextInt(4);
        CastleNode node = null;
        switch (side) {
            case 0: {
                node = this.grid[this.cutX][this.cutY + (this.height - this.cutH - this.cutY) / 2];
                break;
            }
            case 1: {
                node = this.grid[this.cutX + (this.width - this.cutW - this.cutX) / 2][this.cutY];
                break;
            }
            case 2: {
                node = this.grid[this.width - 1 - this.cutW][this.cutY + (this.height - this.cutH - this.cutY) / 2];
                break;
            }
            case 3: {
                node = this.grid[this.cutX + (this.width - this.cutW - this.cutX) / 2][this.height - 1 - this.cutH];
            }
        }
        return node;
    }

    public boolean isSmall() {
        return this.getRealWidth() < 2 || this.getRealHeight() < 2;
    }

    public CastleLayer nextLayer() {
        CastleLayer layer = new CastleLayer(this.cutX, this.cutY, this.cutW, this.cutH, this.width, this.height, this.level + 1);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.grid[x][y].getState() != CastleNodeState.TOWER) continue;
                CastleNode node = layer.grid[x][y];
                node.setState(CastleNodeState.TOWER);
                node.setStairs(true);
                node.setStairsBelow(true);
            }
        }
        return layer;
    }

    private boolean isOutsideBounds(CastleNode node, Position pos) {
        return node.getX() + pos.getX() < 0 || node.getY() + pos.getY() < 0 || node.getX() + pos.getX() >= this.width || node.getY() + pos.getY() >= this.height;
    }

    private boolean isOutsideCuttedBounds(CastleNode node, Position pos) {
        return node.getX() + pos.getX() < this.cutX || node.getY() + pos.getY() < this.cutY || node.getX() + pos.getX() >= this.width - this.cutW || node.getY() + pos.getY() >= this.height - this.cutH;
    }

    public int getRealWidth() {
        return this.width - this.cutW - this.cutX;
    }

    public int getRealHeight() {
        return this.height - this.cutH - this.cutY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getCutX() {
        return this.cutX;
    }

    public int getCutY() {
        return this.cutY;
    }

    public int getCutW() {
        return this.cutW;
    }

    public int getCutH() {
        return this.cutH;
    }

    public CastleNode[][] getGrid() {
        return this.grid;
    }
}

