/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.client.model;

import cech12.ceramicbucket.util.CeramicBucketUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

public class CeramicBucketModel
implements IModelGeometry<CeramicBucketModel> {
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final Fluid fluid;
    private final boolean isCracked;

    public CeramicBucketModel(@Nonnull Fluid fluid) {
        this.fluid = fluid;
        this.isCracked = CeramicBucketUtils.isFluidTooHotForCeramicBucket(fluid);
    }

    public CeramicBucketModel withFluid(Fluid newFluid) {
        return new CeramicBucketModel(newFluid);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        RenderMaterial baseLocation;
        RenderMaterial particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        RenderMaterial renderMaterial = baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        if (this.isCracked && owner.isTexturePresent("crackedBase")) {
            baseLocation = owner.resolveTexture("crackedBase");
        }
        RenderMaterial fluidMaskLocation = owner.isTexturePresent("fluid") ? owner.resolveTexture("fluid") : null;
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.field_204541_a ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)this.fluid.getAttributes().getStillTexture())) : null;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (this.fluid != Fluids.field_204541_a && this.fluid.getAttributes().isLighterThanAir()) {
            modelTransform = new SimpleModelTransform(modelTransform.func_225615_b_().blockCornerToCenter().func_227985_a_(new TransformationMatrix(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)).blockCenterToCorner());
        }
        TransformationMatrix transform = modelTransform.func_225615_b_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrideList)new ContainedFluidOverrideHandler(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseLocation), (TransformationMatrix)transform, spriteGetter));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = this.fluid.getAttributes().getLuminosity();
            int color = this.fluid.getAttributes().getColor();
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)true), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)1, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)true), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)1, (int)luminosity));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("crackedBase")) {
            texs.add(owner.resolveTexture("crackedBase"));
        }
        if (owner.isTexturePresent("fluid")) {
            texs.add(owner.resolveTexture("fluid"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrideList {
        private final Map<String, IBakedModel> cache = Maps.newHashMap();
        private final ItemOverrideList nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final CeramicBucketModel parent;

        private ContainedFluidOverrideHandler(ItemOverrideList nested, ModelBakery bakery, IModelConfiguration owner, CeramicBucketModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            IBakedModel overriden = this.nested.func_239290_a_(originalModel, stack, world, entity);
            if (overriden != originalModel) {
                return overriden;
            }
            return (IBakedModel)FluidUtil.getFluidContained((ItemStack)stack).map(fluidStack -> {
                Fluid fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!this.cache.containsKey(name)) {
                    CeramicBucketModel unbaked = this.parent.withFluid(fluid);
                    IBakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, this, new ResourceLocation("forge:bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse((Object)originalModel);
        }
    }

    public static enum Loader implements IModelLoader<CeramicBucketModel>
    {
        INSTANCE;


        public IResourceType getResourceType() {
            return VanillaResourceType.MODELS;
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        }

        public CeramicBucketModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new CeramicBucketModel(Fluids.field_204541_a);
        }
    }
}

