/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.item;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.item.FilledCeramicBucketItem;
import cech12.ceramicbucket.util.CeramicBucketUtils;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class CeramicMilkBucketItem
extends FilledCeramicBucketItem {
    public CeramicMilkBucketItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public ItemStack getFilledInstance(@Nonnull Fluid fluid) {
        if (CeramicBucketUtils.isMilkFluid(fluid)) {
            return super.getFilledInstance(fluid);
        }
        return super.getFilledInstance(Fluids.field_204541_a);
    }

    public ItemStack getFilledInstance(boolean checkTag) {
        for (Fluid fluid : ForgeRegistries.FLUIDS) {
            if (!fluid.func_207188_f().func_206889_d() || !CeramicBucketUtils.isMilkFluid(fluid, checkTag)) continue;
            return super.getFilledInstance(fluid);
        }
        return super.getFilledInstance(Fluids.field_204541_a);
    }

    @Nonnull
    public ItemStack getFilledInstance() {
        return this.getFilledInstance(true);
    }

    @Override
    @Nonnull
    public ItemStack func_190903_i() {
        return this.getFilledInstance();
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, @Nonnull LivingEntity entityLiving) {
        ItemStack vanillaStack = new ItemStack((IItemProvider)Items.field_151117_aB);
        if (!worldIn.field_72995_K) {
            entityLiving.curePotionEffects(vanillaStack);
        }
        if (entityLiving instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entityLiving;
            CriteriaTriggers.field_193138_y.func_193148_a(serverplayerentity, vanillaStack);
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        if (entityLiving instanceof PlayerEntity && !((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return stack.func_190926_b() ? new ItemStack((IItemProvider)CeramicBucketItems.CERAMIC_BUCKET) : stack;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.DRINK;
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ActionResult result = super.func_77659_a(worldIn, playerIn, handIn);
        if (result.func_188397_a() != ActionResultType.SUCCESS) {
            playerIn.func_184598_c(handIn);
            result = new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        return result;
    }

    @Override
    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.getFilledInstance(false));
        }
    }

    @Override
    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return new TranslationTextComponent("item.ceramicbucket.ceramic_milk_bucket");
    }
}

