/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.util;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.config.Config;
import cech12.ceramicbucket.item.CeramicMilkBucketItem;
import cech12.ceramicbucket.item.FilledCeramicBucketItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class CeramicBucketUtils {
    private static final ITag.INamedTag<Fluid> MILK_TAG = FluidTags.func_206956_a((String)"forge:milk");
    private static final List<ResourceLocation> MILK_FLUIDS = new ArrayList<ResourceLocation>();

    public static boolean isMilkFluid(@Nonnull Fluid fluid, boolean checkTag) {
        if (checkTag && fluid.func_207185_a(MILK_TAG)) {
            return true;
        }
        ResourceLocation location = fluid.func_204524_b().getRegistryName();
        if (location != null && location.equals((Object)Items.field_151117_aB.getRegistryName())) {
            return true;
        }
        for (ResourceLocation name : MILK_FLUIDS) {
            if (!name.equals((Object)fluid.getRegistryName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMilkFluid(@Nonnull Fluid fluid) {
        return CeramicBucketUtils.isMilkFluid(fluid, true);
    }

    public static boolean isFluidTooHotForCeramicBucket(@Nonnull Fluid fluid) {
        int minBreakTemperature = Config.CERAMIC_BUCKET_BREAK_TEMPERATURE.getValue();
        return minBreakTemperature >= 0 && fluid.getAttributes().getTemperature() >= minBreakTemperature;
    }

    public static ItemStack getFilledCeramicBucket(Fluid fluid) {
        if (CeramicBucketUtils.isMilkFluid(fluid)) {
            return ((CeramicMilkBucketItem)CeramicBucketItems.CERAMIC_MILK_BUCKET).getFilledInstance(fluid);
        }
        return ((FilledCeramicBucketItem)CeramicBucketItems.FILLED_CERAMIC_BUCKET).getFilledInstance(fluid);
    }

    static {
        MILK_FLUIDS.add(new ResourceLocation("milk"));
        MILK_FLUIDS.add(new ResourceLocation("industrialforegoing:milk"));
    }
}

