/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.compat.ModCompat;
import cech12.ceramicbucket.config.Config;
import cech12.ceramicbucket.item.CeramicFishBucketItem;
import cech12.ceramicbucket.item.CeramicMilkBucketItem;
import cech12.ceramicbucket.item.FilledCeramicBucketItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="ceramicbucket")
@Mod.EventBusSubscriber
public class CeramicBucketMod {
    public static final String MOD_ID = "ceramicbucket";

    public CeramicBucketMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON, "ceramicbucket-common.toml");
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getTarget();
        if (entity instanceof CowEntity || ModCompat.canEntityBeMilked(entity)) {
            PlayerEntity player = event.getPlayer();
            ItemStack itemstack = player.func_184586_b(event.getHand());
            if (itemstack.func_77973_b() == CeramicBucketItems.CERAMIC_BUCKET && !player.field_71075_bZ.field_75098_d && !entity.func_70631_g_()) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                if (!event.getWorld().func_201670_d()) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(event.getHand(), ((CeramicMilkBucketItem)CeramicBucketItems.CERAMIC_MILK_BUCKET).getFilledInstance());
                    } else if (!player.field_71071_by.func_70441_a(((CeramicMilkBucketItem)CeramicBucketItems.CERAMIC_MILK_BUCKET).getFilledInstance())) {
                        player.func_71019_a(((CeramicMilkBucketItem)CeramicBucketItems.CERAMIC_MILK_BUCKET).getFilledInstance(), false);
                    }
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        } else if (entity instanceof AbstractFishEntity) {
            AbstractFishEntity fishEntity = (AbstractFishEntity)entity;
            PlayerEntity player = event.getPlayer();
            ItemStack itemstack = player.func_184586_b(event.getHand());
            if (itemstack.func_77973_b() == CeramicBucketItems.FILLED_CERAMIC_BUCKET && ((FilledCeramicBucketItem)itemstack.func_77973_b()).getFluid(itemstack) == Fluids.field_204546_a && fishEntity.func_70089_S()) {
                fishEntity.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
                if (!event.getWorld().func_201670_d()) {
                    itemstack.func_190918_g(1);
                    ItemStack bucket = fishEntity instanceof PufferfishEntity ? ((CeramicFishBucketItem)CeramicBucketItems.PUFFERFISH_CERAMIC_BUCKET).getFilledInstance() : (fishEntity instanceof CodEntity ? ((CeramicFishBucketItem)CeramicBucketItems.COD_CERAMIC_BUCKET).getFilledInstance() : (fishEntity instanceof TropicalFishEntity ? ((CeramicFishBucketItem)CeramicBucketItems.TROPICAL_FISH_CERAMIC_BUCKET).getFilledInstance() : ((CeramicFishBucketItem)CeramicBucketItems.SALMON_CERAMIC_BUCKET).getFilledInstance()));
                    if (fishEntity.func_145818_k_()) {
                        bucket.func_200302_a(fishEntity.func_200201_e());
                    }
                    if (fishEntity instanceof TropicalFishEntity) {
                        CompoundNBT compoundnbt = bucket.func_196082_o();
                        compoundnbt.func_74768_a("BucketVariantTag", ((TropicalFishEntity)fishEntity).func_204221_dB());
                    }
                    if (!fishEntity.field_70170_p.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
                    }
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(event.getHand(), bucket);
                    } else if (!player.field_71071_by.func_70441_a(bucket)) {
                        player.func_71019_a(bucket, false);
                    }
                    fishEntity.func_70106_y();
                }
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }
}

