/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.init;

import cech12.ceramicbucket.api.item.CeramicBucketItems;
import cech12.ceramicbucket.item.CeramicBucketItem;
import cech12.ceramicbucket.item.CeramicFishBucketItem;
import cech12.ceramicbucket.item.CeramicMilkBucketItem;
import cech12.ceramicbucket.item.FilledCeramicBucketItem;
import cech12.ceramicbucket.util.CeramicBucketUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ceramicbucket", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        CeramicBucketItems.UNFIRED_CLAY_BUCKET = ModItems.registerItem("unfired_clay_bucket", new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.CERAMIC_BUCKET = ModItems.registerItem("ceramic_bucket", (Item)new CeramicBucketItem(new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.FILLED_CERAMIC_BUCKET = ModItems.registerItem("filled_ceramic_bucket", (Item)new FilledCeramicBucketItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.CERAMIC_MILK_BUCKET = ModItems.registerItem("ceramic_milk_bucket", (Item)new CeramicMilkBucketItem(new Item.Properties().func_200919_a(CeramicBucketItems.CERAMIC_BUCKET).func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.PUFFERFISH_CERAMIC_BUCKET = ModItems.registerItem("pufferfish_ceramic_bucket", (Item)new CeramicFishBucketItem(EntityType.field_203779_Z, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.SALMON_CERAMIC_BUCKET = ModItems.registerItem("salmon_ceramic_bucket", (Item)new CeramicFishBucketItem(EntityType.field_203778_ae, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.COD_CERAMIC_BUCKET = ModItems.registerItem("cod_ceramic_bucket", (Item)new CeramicFishBucketItem(EntityType.field_203780_j, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        CeramicBucketItems.TROPICAL_FISH_CERAMIC_BUCKET = ModItems.registerItem("tropical_fish_ceramic_bucket", (Item)new CeramicFishBucketItem(EntityType.field_204262_at, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)));
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.CERAMIC_BUCKET, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior();

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                ServerWorld iworld = source.func_197524_h();
                BlockState blockstate = iworld.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
                Block block = blockstate.func_177230_c();
                if (block instanceof IBucketPickupHandler) {
                    Fluid fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)iworld, blockpos, blockstate);
                    if (!(fluid instanceof FlowingFluid)) {
                        return super.func_82487_b(source, stack);
                    }
                    ItemStack bucket = CeramicBucketUtils.getFilledCeramicBucket(fluid);
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        return bucket;
                    }
                    if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(bucket) < 0) {
                        this.dispenseBehavior.dispense(source, bucket);
                    }
                    return stack;
                }
                return super.func_82487_b(source, stack);
            }
        });
        DefaultDispenseItemBehavior idispenseitembehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior dispenseBehaviour = new DefaultDispenseItemBehavior();

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                FilledCeramicBucketItem bucketItem = (FilledCeramicBucketItem)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                ServerWorld world = source.func_197524_h();
                if (bucketItem.tryPlaceContainedLiquid(null, (World)world, blockpos, null, stack)) {
                    bucketItem.func_203792_a((World)world, stack, blockpos);
                    return bucketItem.func_203790_a(stack, null);
                }
                return this.dispenseBehaviour.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.FILLED_CERAMIC_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.CERAMIC_MILK_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.PUFFERFISH_CERAMIC_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.SALMON_CERAMIC_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.COD_CERAMIC_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)CeramicBucketItems.TROPICAL_FISH_CERAMIC_BUCKET, (IDispenseItemBehavior)idispenseitembehavior);
    }

    private static Item registerItem(String name, Item item) {
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }
}

