/*
 * Decompiled with CFR 0.152.
 */
package cech12.ceramicbucket.item;

import cech12.ceramicbucket.item.CeramicFishBucketItem;
import cech12.ceramicbucket.util.CeramicBucketUtils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public abstract class AbstractCeramicBucketItem
extends BucketItem {
    public AbstractCeramicBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    @Nonnull
    abstract FluidHandlerItemStack getNewFluidHandlerInstance(@Nonnull ItemStack var1);

    public ICapabilityProvider initCapabilities(final @Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? LazyOptional.of(() -> AbstractCeramicBucketItem.this.getNewFluidHandlerInstance(stack)) : LazyOptional.empty();
            }
        };
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack;
        BlockRayTraceResult raytraceresult = AbstractCeramicBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.getFluid(itemstack = playerIn.func_184586_b(handIn)) == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)raytraceresult);
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            BlockPos blockpos1;
            Fluid fluid;
            BlockState blockstate1;
            if (this.getFluid(itemstack) == Fluids.field_204541_a && (blockstate1 = worldIn.func_180495_p(blockpos)).func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) != Fluids.field_204541_a) {
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                SoundEvent soundevent = this.getFluid(itemstack).getAttributes().getEmptySound();
                if (soundevent == null) {
                    soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                }
                playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                ItemStack itemstack1 = this.fillBucket(itemstack, playerIn, fluid);
                if (!worldIn.field_72995_K) {
                    CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)fluid.func_204524_b()));
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack1);
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (blockstate.func_177230_c() == Blocks.field_150383_bp) {
                fluid = this.getFluid(itemstack);
                CauldronBlock cauldron = (CauldronBlock)blockstate.func_177230_c();
                int level = (Integer)blockstate.func_177229_b((Property)CauldronBlock.field_176591_a);
                if (fluid.func_207185_a((ITag)FluidTags.field_206959_a) && !(itemstack.func_77973_b() instanceof CeramicFishBucketItem)) {
                    if (level < 3) {
                        itemstack = this.func_203790_a(itemstack, playerIn);
                        if (!worldIn.field_72995_K) {
                            playerIn.func_195066_a(Stats.field_188077_K);
                            cauldron.func_176590_a(worldIn, blockpos, blockstate, 3);
                            this.func_203791_b(playerIn, (IWorld)worldIn, blockpos);
                        }
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
                }
                if (fluid == Fluids.field_204541_a) {
                    if (level == 3) {
                        itemstack = this.fillBucket(itemstack, playerIn, (Fluid)Fluids.field_204546_a);
                        if (!worldIn.field_72995_K) {
                            playerIn.func_195066_a(Stats.field_188078_L);
                            cauldron.func_176590_a(worldIn, blockpos, blockstate, 0);
                            worldIn.func_184133_a(null, blockpos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
                }
            }
            BlockPos blockPos = blockpos1 = this.canBlockContainFluid(worldIn, blockpos, blockstate, itemstack) ? blockpos : blockraytraceresult.func_216350_a().func_177972_a(blockraytraceresult.func_216354_b());
            if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos1, blockraytraceresult, itemstack)) {
                this.func_203792_a(worldIn, itemstack, blockpos1);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos1, itemstack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return new ActionResult(ActionResultType.SUCCESS, (Object)this.func_203790_a(itemstack, playerIn));
            }
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    private ItemStack fillBucket(ItemStack stack, PlayerEntity player, Fluid fluid) {
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            if (stack.func_190916_E() > 1) {
                stack.func_190918_g(1);
                ItemStack newStack = CeramicBucketUtils.getFilledCeramicBucket(fluid);
                if (player != null && !player.field_71071_by.func_70441_a(newStack)) {
                    player.func_71019_a(newStack, false);
                }
            } else {
                return this.fill(stack, new FluidStack(fluid, 1000));
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_203790_a(@Nonnull ItemStack stack, PlayerEntity player) {
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            return this.drain(stack, 1000);
        }
        return stack;
    }

    @Deprecated
    public boolean func_180616_a(@Nullable PlayerEntity player, @Nonnull World worldIn, @Nonnull BlockPos posIn, @Nullable BlockRayTraceResult raytrace) {
        return false;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult raytrace, ItemStack stack) {
        Fluid fluid = this.getFluid(stack);
        FluidAttributes fluidAttributes = fluid.getAttributes();
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        if (!fluidAttributes.canBePlacedInWorld((IBlockDisplayReader)worldIn, posIn, fluid.func_207188_f())) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = material.func_76222_j();
        boolean canContainFluid = this.canBlockContainFluid(worldIn, posIn, blockstate, stack);
        if (worldIn.func_175623_d(posIn) || flag || flag1 || canContainFluid) {
            FluidStack fluidStack;
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            FluidStack fluidStack2 = fluidStack = fluidHandler != null ? fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE) : null;
            if (fluidStack != null && worldIn.func_230315_m_().func_236040_e_() && this.getFluid(stack).func_207185_a((ITag)FluidTags.field_206959_a)) {
                fluidAttributes.vaporize(player, worldIn, posIn, fluidStack);
            } else if (canContainFluid) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)fluid).func_207204_a(false))) {
                    this.func_203791_b(player, (IWorld)worldIn, posIn);
                }
            } else {
                if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.func_203791_b(player, (IWorld)worldIn, posIn);
                worldIn.func_180501_a(posIn, fluid.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return raytrace != null && this.tryPlaceContainedLiquid(player, worldIn, raytrace.func_216350_a().func_177972_a(raytrace.func_216354_b()), null, stack);
    }

    @Deprecated
    @Nonnull
    public Fluid getFluid() {
        return Fluids.field_204541_a;
    }

    public Fluid getFluid(ItemStack stack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            FluidHandlerItemStack fluidHandler = (FluidHandlerItemStack)cap.orElseThrow(NullPointerException::new);
            return fluidHandler.getFluid().getFluid();
        }
        return Fluids.field_204541_a;
    }

    public ItemStack fill(ItemStack stack, FluidStack fluidStack) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            FluidHandlerItemStack fluidHandler = (FluidHandlerItemStack)cap.orElseThrow(NullPointerException::new);
            fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return fluidHandler.getContainer();
        }
        return stack;
    }

    public ItemStack drain(ItemStack stack, int drainAmount) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap.isPresent()) {
            FluidHandlerItemStack fluidHandler = (FluidHandlerItemStack)cap.orElseThrow(NullPointerException::new);
            fluidHandler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            return fluidHandler.getContainer();
        }
        return stack;
    }

    private boolean canBlockContainFluid(World worldIn, BlockPos posIn, BlockState blockstate, ItemStack itemStack) {
        return blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.getFluid(itemStack));
    }
}

